@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.changeanalysis.kotlin.inputs

import com.pulumi.azurenative.changeanalysis.inputs.NotificationSettingsArgs.builder
import com.pulumi.azurenative.changeanalysis.kotlin.enums.NotificationsState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Settings of change notification configuration for a subscription.
 * @property activationState The state of notifications feature.
 * @property azureMonitorWorkspaceProperties Configuration properties of an Azure Monitor workspace that receives change notifications.
 */
public data class NotificationSettingsArgs(
    public val activationState: Output<Either<String, NotificationsState>>? = null,
    public val azureMonitorWorkspaceProperties: Output<AzureMonitorWorkspacePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.changeanalysis.inputs.NotificationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.changeanalysis.inputs.NotificationSettingsArgs =
        com.pulumi.azurenative.changeanalysis.inputs.NotificationSettingsArgs.builder()
            .activationState(
                activationState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureMonitorWorkspaceProperties(
                azureMonitorWorkspaceProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [NotificationSettingsArgs].
 */
@PulumiTagMarker
public class NotificationSettingsArgsBuilder internal constructor() {
    private var activationState: Output<Either<String, NotificationsState>>? = null

    private var azureMonitorWorkspaceProperties: Output<AzureMonitorWorkspacePropertiesArgs>? = null

    /**
     * @param value The state of notifications feature.
     */
    @JvmName("pxbyercnqvmnuglv")
    public suspend fun activationState(`value`: Output<Either<String, NotificationsState>>) {
        this.activationState = value
    }

    /**
     * @param value Configuration properties of an Azure Monitor workspace that receives change notifications.
     */
    @JvmName("cnqfhnpfligqleuo")
    public suspend
    fun azureMonitorWorkspaceProperties(`value`: Output<AzureMonitorWorkspacePropertiesArgs>) {
        this.azureMonitorWorkspaceProperties = value
    }

    /**
     * @param value The state of notifications feature.
     */
    @JvmName("fnbwbxkjlgpmhxjo")
    public suspend fun activationState(`value`: Either<String, NotificationsState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value The state of notifications feature.
     */
    @JvmName("fcrtpnxydwogteic")
    public fun activationState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value The state of notifications feature.
     */
    @JvmName("lfkcagvxigcckadc")
    public fun activationState(`value`: NotificationsState) {
        val toBeMapped = Either.ofRight<String, NotificationsState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Configuration properties of an Azure Monitor workspace that receives change notifications.
     */
    @JvmName("mocfkbuecnpttoij")
    public suspend
    fun azureMonitorWorkspaceProperties(`value`: AzureMonitorWorkspacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureMonitorWorkspaceProperties = mapped
    }

    /**
     * @param argument Configuration properties of an Azure Monitor workspace that receives change notifications.
     */
    @JvmName("wpqrhbsnricetndd")
    public suspend
    fun azureMonitorWorkspaceProperties(argument: suspend AzureMonitorWorkspacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AzureMonitorWorkspacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.azureMonitorWorkspaceProperties = mapped
    }

    internal fun build(): NotificationSettingsArgs = NotificationSettingsArgs(
        activationState = activationState,
        azureMonitorWorkspaceProperties = azureMonitorWorkspaceProperties,
    )
}
