@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.ChaosFunctions.getCapabilityPlain
import com.pulumi.azurenative.chaos.ChaosFunctions.getExperimentExecutionDetailsPlain
import com.pulumi.azurenative.chaos.ChaosFunctions.getExperimentPlain
import com.pulumi.azurenative.chaos.ChaosFunctions.getPrivateAccessPlain
import com.pulumi.azurenative.chaos.ChaosFunctions.getTargetPlain
import com.pulumi.azurenative.chaos.kotlin.inputs.GetCapabilityPlainArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.GetCapabilityPlainArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.inputs.GetExperimentExecutionDetailsPlainArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.GetExperimentExecutionDetailsPlainArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.inputs.GetExperimentPlainArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.GetExperimentPlainArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.inputs.GetPrivateAccessPlainArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.GetPrivateAccessPlainArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.inputs.GetTargetPlainArgs
import com.pulumi.azurenative.chaos.kotlin.inputs.GetTargetPlainArgsBuilder
import com.pulumi.azurenative.chaos.kotlin.outputs.GetCapabilityResult
import com.pulumi.azurenative.chaos.kotlin.outputs.GetExperimentExecutionDetailsResult
import com.pulumi.azurenative.chaos.kotlin.outputs.GetExperimentResult
import com.pulumi.azurenative.chaos.kotlin.outputs.GetPrivateAccessResult
import com.pulumi.azurenative.chaos.kotlin.outputs.GetTargetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.chaos.kotlin.outputs.GetCapabilityResult.Companion.toKotlin as getCapabilityResultToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.GetExperimentExecutionDetailsResult.Companion.toKotlin as getExperimentExecutionDetailsResultToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.GetExperimentResult.Companion.toKotlin as getExperimentResultToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.GetPrivateAccessResult.Companion.toKotlin as getPrivateAccessResultToKotlin
import com.pulumi.azurenative.chaos.kotlin.outputs.GetTargetResult.Companion.toKotlin as getTargetResultToKotlin

public object ChaosFunctions {
    /**
     * Get a Capability resource that extends a Target resource.
     * Azure REST API version: 2023-04-15-preview.
     * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01.
     * @param argument null
     * @return Model that represents a Capability resource.
     */
    public suspend fun getCapability(argument: GetCapabilityPlainArgs): GetCapabilityResult =
        getCapabilityResultToKotlin(getCapabilityPlain(argument.toJava()).await())

    /**
     * @see [getCapability].
     * @param capabilityName String that represents a Capability resource name.
     * @param parentProviderNamespace String that represents a resource provider namespace.
     * @param parentResourceName String that represents a resource name.
     * @param parentResourceType String that represents a resource type.
     * @param resourceGroupName String that represents an Azure resource group.
     * @param targetName String that represents a Target resource name.
     * @return Model that represents a Capability resource.
     */
    public suspend fun getCapability(
        capabilityName: String,
        parentProviderNamespace: String,
        parentResourceName: String,
        parentResourceType: String,
        resourceGroupName: String,
        targetName: String,
    ): GetCapabilityResult {
        val argument = GetCapabilityPlainArgs(
            capabilityName = capabilityName,
            parentProviderNamespace = parentProviderNamespace,
            parentResourceName = parentResourceName,
            parentResourceType = parentResourceType,
            resourceGroupName = resourceGroupName,
            targetName = targetName,
        )
        return getCapabilityResultToKotlin(getCapabilityPlain(argument.toJava()).await())
    }

    /**
     * @see [getCapability].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;chaos&#46;kotlin&#46;inputs&#46;GetCapabilityPlainArgs].
     * @return Model that represents a Capability resource.
     */
    public suspend fun getCapability(argument: suspend GetCapabilityPlainArgsBuilder.() -> Unit):
        GetCapabilityResult {
        val builder = GetCapabilityPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCapabilityResultToKotlin(getCapabilityPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Experiment resource.
     * Azure REST API version: 2023-04-15-preview.
     * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01.
     * @param argument null
     * @return Model that represents a Experiment resource.
     */
    public suspend fun getExperiment(argument: GetExperimentPlainArgs): GetExperimentResult =
        getExperimentResultToKotlin(getExperimentPlain(argument.toJava()).await())

    /**
     * @see [getExperiment].
     * @param experimentName String that represents a Experiment resource name.
     * @param resourceGroupName String that represents an Azure resource group.
     * @return Model that represents a Experiment resource.
     */
    public suspend fun getExperiment(experimentName: String, resourceGroupName: String):
        GetExperimentResult {
        val argument = GetExperimentPlainArgs(
            experimentName = experimentName,
            resourceGroupName = resourceGroupName,
        )
        return getExperimentResultToKotlin(getExperimentPlain(argument.toJava()).await())
    }

    /**
     * @see [getExperiment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;chaos&#46;kotlin&#46;inputs&#46;GetExperimentPlainArgs].
     * @return Model that represents a Experiment resource.
     */
    public suspend fun getExperiment(argument: suspend GetExperimentPlainArgsBuilder.() -> Unit):
        GetExperimentResult {
        val builder = GetExperimentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExperimentResultToKotlin(getExperimentPlain(builtArgument.toJava()).await())
    }

    /**
     * Execution details of an experiment resource.
     * Azure REST API version: 2023-11-01.
     * @param argument null
     * @return Model that represents the execution details of an Experiment.
     */
    public suspend
    fun getExperimentExecutionDetails(argument: GetExperimentExecutionDetailsPlainArgs):
        GetExperimentExecutionDetailsResult =
        getExperimentExecutionDetailsResultToKotlin(getExperimentExecutionDetailsPlain(argument.toJava()).await())

    /**
     * @see [getExperimentExecutionDetails].
     * @param executionId GUID that represents a Experiment execution detail.
     * @param experimentName String that represents a Experiment resource name.
     * @param resourceGroupName String that represents an Azure resource group.
     * @return Model that represents the execution details of an Experiment.
     */
    public suspend fun getExperimentExecutionDetails(
        executionId: String,
        experimentName: String,
        resourceGroupName: String,
    ): GetExperimentExecutionDetailsResult {
        val argument = GetExperimentExecutionDetailsPlainArgs(
            executionId = executionId,
            experimentName = experimentName,
            resourceGroupName = resourceGroupName,
        )
        return getExperimentExecutionDetailsResultToKotlin(getExperimentExecutionDetailsPlain(argument.toJava()).await())
    }

    /**
     * @see [getExperimentExecutionDetails].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;chaos&#46;kotlin&#46;inputs&#46;GetExperimentExecutionDetailsPlainArgs].
     * @return Model that represents the execution details of an Experiment.
     */
    public suspend
    fun getExperimentExecutionDetails(argument: suspend GetExperimentExecutionDetailsPlainArgsBuilder.() -> Unit):
        GetExperimentExecutionDetailsResult {
        val builder = GetExperimentExecutionDetailsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExperimentExecutionDetailsResultToKotlin(getExperimentExecutionDetailsPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a private access resource
     * Azure REST API version: 2023-10-27-preview.
     * @param argument null
     * @return PrivateAccesses tracked resource.
     */
    public suspend fun getPrivateAccess(argument: GetPrivateAccessPlainArgs): GetPrivateAccessResult =
        getPrivateAccessResultToKotlin(getPrivateAccessPlain(argument.toJava()).await())

    /**
     * @see [getPrivateAccess].
     * @param privateAccessName The name of the private access resource that is being created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The maximum name length is 80 characters.
     * @param resourceGroupName String that represents an Azure resource group.
     * @return PrivateAccesses tracked resource.
     */
    public suspend fun getPrivateAccess(privateAccessName: String, resourceGroupName: String):
        GetPrivateAccessResult {
        val argument = GetPrivateAccessPlainArgs(
            privateAccessName = privateAccessName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateAccessResultToKotlin(getPrivateAccessPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateAccess].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;chaos&#46;kotlin&#46;inputs&#46;GetPrivateAccessPlainArgs].
     * @return PrivateAccesses tracked resource.
     */
    public suspend
    fun getPrivateAccess(argument: suspend GetPrivateAccessPlainArgsBuilder.() -> Unit):
        GetPrivateAccessResult {
        val builder = GetPrivateAccessPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateAccessResultToKotlin(getPrivateAccessPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a Target resource that extends a tracked regional resource.
     * Azure REST API version: 2023-04-15-preview.
     * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01.
     * @param argument null
     * @return Model that represents a Target resource.
     */
    public suspend fun getTarget(argument: GetTargetPlainArgs): GetTargetResult =
        getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())

    /**
     * @see [getTarget].
     * @param parentProviderNamespace String that represents a resource provider namespace.
     * @param parentResourceName String that represents a resource name.
     * @param parentResourceType String that represents a resource type.
     * @param resourceGroupName String that represents an Azure resource group.
     * @param targetName String that represents a Target resource name.
     * @return Model that represents a Target resource.
     */
    public suspend fun getTarget(
        parentProviderNamespace: String,
        parentResourceName: String,
        parentResourceType: String,
        resourceGroupName: String,
        targetName: String,
    ): GetTargetResult {
        val argument = GetTargetPlainArgs(
            parentProviderNamespace = parentProviderNamespace,
            parentResourceName = parentResourceName,
            parentResourceType = parentResourceType,
            resourceGroupName = resourceGroupName,
            targetName = targetName,
        )
        return getTargetResultToKotlin(getTargetPlain(argument.toJava()).await())
    }

    /**
     * @see [getTarget].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;chaos&#46;kotlin&#46;inputs&#46;GetTargetPlainArgs].
     * @return Model that represents a Target resource.
     */
    public suspend fun getTarget(argument: suspend GetTargetPlainArgsBuilder.() -> Unit):
        GetTargetResult {
        val builder = GetTargetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTargetResultToKotlin(getTargetPlain(builtArgument.toJava()).await())
    }
}
