@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin

import com.pulumi.azurenative.chaos.TargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model that represents a Target resource.
 * Azure REST API version: 2023-04-15-preview. Prior API version in Azure Native 1.x: 2021-09-15-preview.
 * Other available API versions: 2023-09-01-preview, 2023-10-27-preview, 2023-11-01.
 * ## Example Usage
 * ### Create/update a Target that extends a virtual machine resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var target = new AzureNative.Chaos.Target("target", new()
 *     {
 *         ParentProviderNamespace = "Microsoft.Compute",
 *         ParentResourceName = "exampleVM",
 *         ParentResourceType = "virtualMachines",
 *         Properties =
 *         {
 *             { "identities", new[]
 *             {
 *                 {
 *                     { "subject", "CN=example.subject" },
 *                     { "type", "CertificateSubjectIssuer" },
 *                 },
 *             } },
 *         },
 *         ResourceGroupName = "exampleRG",
 *         TargetName = "Microsoft-Agent",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/chaos/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := chaos.NewTarget(ctx, "target", &chaos.TargetArgs{
 * 			ParentProviderNamespace: pulumi.String("Microsoft.Compute"),
 * 			ParentResourceName:      pulumi.String("exampleVM"),
 * 			ParentResourceType:      pulumi.String("virtualMachines"),
 * 			Properties: pulumi.Any{
 * 				Identities: []map[string]interface{}{
 * 					map[string]interface{}{
 * 						"subject": "CN=example.subject",
 * 						"type":    "CertificateSubjectIssuer",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleRG"),
 * 			TargetName:        pulumi.String("Microsoft-Agent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.chaos.Target;
 * import com.pulumi.azurenative.chaos.TargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var target = new Target("target", TargetArgs.builder()
 *             .parentProviderNamespace("Microsoft.Compute")
 *             .parentResourceName("exampleVM")
 *             .parentResourceType("virtualMachines")
 *             .properties(Map.of("identities", Map.ofEntries(
 *                 Map.entry("subject", "CN=example.subject"),
 *                 Map.entry("type", "CertificateSubjectIssuer")
 *             )))
 *             .resourceGroupName("exampleRG")
 *             .targetName("Microsoft-Agent")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:chaos:Target Microsoft-Agent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{parentProviderNamespace}/{parentResourceType}/{parentResourceName}/providers/Microsoft.Chaos/targets/{targetName}
 * ```
 * @property location Location of the target resource.
 * @property parentProviderNamespace String that represents a resource provider namespace.
 * @property parentResourceName String that represents a resource name.
 * @property parentResourceType String that represents a resource type.
 * @property properties The properties of the target resource.
 * @property resourceGroupName String that represents an Azure resource group.
 * @property targetName String that represents a Target resource name.
 */
public data class TargetArgs(
    public val location: Output<String>? = null,
    public val parentProviderNamespace: Output<String>? = null,
    public val parentResourceName: Output<String>? = null,
    public val parentResourceType: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val targetName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.TargetArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.TargetArgs =
        com.pulumi.azurenative.chaos.TargetArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .parentProviderNamespace(parentProviderNamespace?.applyValue({ args0 -> args0 }))
            .parentResourceName(parentResourceName?.applyValue({ args0 -> args0 }))
            .parentResourceType(parentResourceType?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .targetName(targetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetArgs].
 */
@PulumiTagMarker
public class TargetArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var parentProviderNamespace: Output<String>? = null

    private var parentResourceName: Output<String>? = null

    private var parentResourceType: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var targetName: Output<String>? = null

    /**
     * @param value Location of the target resource.
     */
    @JvmName("tpjjhncmpvuqpdum")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value String that represents a resource provider namespace.
     */
    @JvmName("vkumeuhkeqpeqmfe")
    public suspend fun parentProviderNamespace(`value`: Output<String>) {
        this.parentProviderNamespace = value
    }

    /**
     * @param value String that represents a resource name.
     */
    @JvmName("doilrhgysbqhxoju")
    public suspend fun parentResourceName(`value`: Output<String>) {
        this.parentResourceName = value
    }

    /**
     * @param value String that represents a resource type.
     */
    @JvmName("erxdhavdpaficopa")
    public suspend fun parentResourceType(`value`: Output<String>) {
        this.parentResourceType = value
    }

    /**
     * @param value The properties of the target resource.
     */
    @JvmName("geygafsinguhylbn")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("qnfvgugnwokgvoiy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value String that represents a Target resource name.
     */
    @JvmName("kknrfethpcielfwv")
    public suspend fun targetName(`value`: Output<String>) {
        this.targetName = value
    }

    /**
     * @param value Location of the target resource.
     */
    @JvmName("jysjkajrosjqemei")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value String that represents a resource provider namespace.
     */
    @JvmName("cwvvbfsjxrpqduga")
    public suspend fun parentProviderNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentProviderNamespace = mapped
    }

    /**
     * @param value String that represents a resource name.
     */
    @JvmName("vmutsdjdfvpwitlv")
    public suspend fun parentResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourceName = mapped
    }

    /**
     * @param value String that represents a resource type.
     */
    @JvmName("vikssbcbhdshddcg")
    public suspend fun parentResourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourceType = mapped
    }

    /**
     * @param value The properties of the target resource.
     */
    @JvmName("ypnlkrpkighknqvw")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("tgcivtamyvenxgcq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value String that represents a Target resource name.
     */
    @JvmName("uyehhkdaeylnsowv")
    public suspend fun targetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetName = mapped
    }

    internal fun build(): TargetArgs = TargetArgs(
        location = location,
        parentProviderNamespace = parentProviderNamespace,
        parentResourceName = parentResourceName,
        parentResourceType = parentResourceType,
        properties = properties,
        resourceGroupName = resourceGroupName,
        targetName = targetName,
    )
}
