@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.DelayActionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Model that represents a delay action.
 * @property duration ISO8601 formatted string that represents a duration.
 * @property name String that represents a Capability URN.
 * @property type Enum that discriminates between action models.
 * Expected value is 'delay'.
 */
public data class DelayActionArgs(
    public val duration: Output<String>,
    public val name: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.DelayActionArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.DelayActionArgs =
        com.pulumi.azurenative.chaos.inputs.DelayActionArgs.builder()
            .duration(duration.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelayActionArgs].
 */
@PulumiTagMarker
public class DelayActionArgsBuilder internal constructor() {
    private var duration: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value ISO8601 formatted string that represents a duration.
     */
    @JvmName("qwbknwqehxucjmwo")
    public suspend fun duration(`value`: Output<String>) {
        this.duration = value
    }

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("ajcnjkijbsnekdiy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'delay'.
     */
    @JvmName("xfsyxqniduuxqebk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ISO8601 formatted string that represents a duration.
     */
    @JvmName("wwpjtvjraihuarpp")
    public suspend fun duration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value String that represents a Capability URN.
     */
    @JvmName("lrcvlmctdjvnraxu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Enum that discriminates between action models.
     * Expected value is 'delay'.
     */
    @JvmName("bpbbygstoirjjgyi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DelayActionArgs = DelayActionArgs(
        duration = duration ?: throw PulumiNullFieldException("duration"),
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
