@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.GetExperimentExecutionDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property executionId GUID that represents a Experiment execution detail.
 * @property experimentName String that represents a Experiment resource name.
 * @property resourceGroupName String that represents an Azure resource group.
 */
public data class GetExperimentExecutionDetailsPlainArgs(
    public val executionId: String,
    public val experimentName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.GetExperimentExecutionDetailsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.GetExperimentExecutionDetailsPlainArgs =
        com.pulumi.azurenative.chaos.inputs.GetExperimentExecutionDetailsPlainArgs.builder()
            .executionId(executionId.let({ args0 -> args0 }))
            .experimentName(experimentName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExperimentExecutionDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetExperimentExecutionDetailsPlainArgsBuilder internal constructor() {
    private var executionId: String? = null

    private var experimentName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value GUID that represents a Experiment execution detail.
     */
    @JvmName("tetvmrrpeqjyifmk")
    public suspend fun executionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.executionId = mapped
    }

    /**
     * @param value String that represents a Experiment resource name.
     */
    @JvmName("ywwxdquefekaxnkx")
    public suspend fun experimentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.experimentName = mapped
    }

    /**
     * @param value String that represents an Azure resource group.
     */
    @JvmName("osdjuusjmlttbfft")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExperimentExecutionDetailsPlainArgs =
        GetExperimentExecutionDetailsPlainArgs(
            executionId = executionId ?: throw PulumiNullFieldException("executionId"),
            experimentName = experimentName ?: throw PulumiNullFieldException("experimentName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
