@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.KeyValuePairArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A map to describe the settings of an action.
 * @property key The name of the setting for the action.
 * @property value The value of the setting for the action.
 */
public data class KeyValuePairArgs(
    public val key: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.KeyValuePairArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.KeyValuePairArgs =
        com.pulumi.azurenative.chaos.inputs.KeyValuePairArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyValuePairArgs].
 */
@PulumiTagMarker
public class KeyValuePairArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the setting for the action.
     */
    @JvmName("wpkikyinycyoimtl")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value The value of the setting for the action.
     */
    @JvmName("kduavmbuijynqchl")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the setting for the action.
     */
    @JvmName("njvcfiioyedpxouy")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value The value of the setting for the action.
     */
    @JvmName("eprorsobdvtghrya")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): KeyValuePairArgs = KeyValuePairArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
