@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.inputs

import com.pulumi.azurenative.chaos.inputs.StepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Model that represents a step in the Experiment resource.
 * @property branches List of branches.
 * @property name String of the step name.
 */
public data class StepArgs(
    public val branches: Output<List<BranchArgs>>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.chaos.inputs.StepArgs> {
    override fun toJava(): com.pulumi.azurenative.chaos.inputs.StepArgs =
        com.pulumi.azurenative.chaos.inputs.StepArgs.builder()
            .branches(
                branches.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StepArgs].
 */
@PulumiTagMarker
public class StepArgsBuilder internal constructor() {
    private var branches: Output<List<BranchArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value List of branches.
     */
    @JvmName("jwkmvnmfycqrxmof")
    public suspend fun branches(`value`: Output<List<BranchArgs>>) {
        this.branches = value
    }

    @JvmName("mlsagxfepqdkfgdt")
    public suspend fun branches(vararg values: Output<BranchArgs>) {
        this.branches = Output.all(values.asList())
    }

    /**
     * @param values List of branches.
     */
    @JvmName("xlkqvyfkghyyyhci")
    public suspend fun branches(values: List<Output<BranchArgs>>) {
        this.branches = Output.all(values)
    }

    /**
     * @param value String of the step name.
     */
    @JvmName("wwkpvwdrydxaaatm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of branches.
     */
    @JvmName("uwltokthedlufodd")
    public suspend fun branches(`value`: List<BranchArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param argument List of branches.
     */
    @JvmName("fmkkfrapktopgukx")
    public suspend fun branches(argument: List<suspend BranchArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BranchArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.branches = mapped
    }

    /**
     * @param argument List of branches.
     */
    @JvmName("slrtytgnupbhxtqp")
    public suspend fun branches(vararg argument: suspend BranchArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BranchArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.branches = mapped
    }

    /**
     * @param argument List of branches.
     */
    @JvmName("gkdxvmrepkkxirdh")
    public suspend fun branches(argument: suspend BranchArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BranchArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.branches = mapped
    }

    /**
     * @param values List of branches.
     */
    @JvmName("nthfmamvkopngkeg")
    public suspend fun branches(vararg values: BranchArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.branches = mapped
    }

    /**
     * @param value String of the step name.
     */
    @JvmName("wnmryjjajtrbmwcc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): StepArgs = StepArgs(
        branches = branches ?: throw PulumiNullFieldException("branches"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
