@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.chaos.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Model that represents the an action and its status.
 * @property actionId The id of the action status.
 * @property actionName The name of the action status.
 * @property endTime String that represents the end time of the action.
 * @property startTime String that represents the start time of the action.
 * @property status The status of the action.
 * @property targets The array of targets.
 */
public data class ActionStatusResponse(
    public val actionId: String,
    public val actionName: String,
    public val endTime: String,
    public val startTime: String,
    public val status: String,
    public val targets: List<ExperimentExecutionActionTargetDetailsPropertiesResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.chaos.outputs.ActionStatusResponse):
            ActionStatusResponse = ActionStatusResponse(
            actionId = javaType.actionId(),
            actionName = javaType.actionName(),
            endTime = javaType.endTime(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            targets = javaType.targets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.chaos.kotlin.outputs.ExperimentExecutionActionTargetDetailsPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
