@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.AccountPropertiesResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.AccountPropertiesResponse.Companion.toKotlin as accountPropertiesResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.cognitiveservices.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Account].
 */
@PulumiTagMarker
public class AccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountArgs = AccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountArgsBuilder.() -> Unit) {
        val builder = AccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Account {
        val builtJavaResource =
            com.pulumi.azurenative.cognitiveservices.Account(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Account(builtJavaResource)
    }
}

/**
 * Cognitive Services account is an Azure resource representing the provisioned account, it's type, location and SKU.
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2017-04-18.
 * Other available API versions: 2017-04-18, 2023-10-01-preview.
 * ## Example Usage
 * ### Create Account
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.CognitiveServices.Account("account", new()
 *     {
 *         AccountName = "testCreate1",
 *         Identity = new AzureNative.CognitiveServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.CognitiveServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = "Emotion",
 *         Location = "West US",
 *         Properties = new AzureNative.CognitiveServices.Inputs.AccountPropertiesArgs
 *         {
 *             Encryption = new AzureNative.CognitiveServices.Inputs.EncryptionArgs
 *             {
 *                 KeySource = "Microsoft.KeyVault",
 *                 KeyVaultProperties = new AzureNative.CognitiveServices.Inputs.KeyVaultPropertiesArgs
 *                 {
 *                     KeyName = "KeyName",
 *                     KeyVaultUri = "https://pltfrmscrts-use-pc-dev.vault.azure.net/",
 *                     KeyVersion = "891CF236-D241-4738-9462-D506AF493DFA",
 *                 },
 *             },
 *             UserOwnedStorage = new[]
 *             {
 *                 new AzureNative.CognitiveServices.Inputs.UserOwnedStorageArgs
 *                 {
 *                     ResourceId = "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := cognitiveservices.NewAccount(ctx, "account", &cognitiveservices.AccountArgs{
 * AccountName: pulumi.String("testCreate1"),
 * Identity: &cognitiveservices.IdentityArgs{
 * Type: cognitiveservices.ResourceIdentityTypeSystemAssigned,
 * },
 * Kind: pulumi.String("Emotion"),
 * Location: pulumi.String("West US"),
 * Properties: cognitiveservices.AccountPropertiesResponse{
 * Encryption: interface{}{
 * KeySource: pulumi.String("Microsoft.KeyVault"),
 * KeyVaultProperties: &cognitiveservices.KeyVaultPropertiesArgs{
 * KeyName: pulumi.String("KeyName"),
 * KeyVaultUri: pulumi.String("https://pltfrmscrts-use-pc-dev.vault.azure.net/"),
 * KeyVersion: pulumi.String("891CF236-D241-4738-9462-D506AF493DFA"),
 * },
 * },
 * UserOwnedStorage: cognitiveservices.UserOwnedStorageArray{
 * &cognitiveservices.UserOwnedStorageArgs{
 * ResourceId: pulumi.String("/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * Sku: &cognitiveservices.SkuArgs{
 * Name: pulumi.String("S0"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Account;
 * import com.pulumi.azurenative.cognitiveservices.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("testCreate1")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .kind("Emotion")
 *             .location("West US")
 *             .properties(Map.ofEntries(
 *                 Map.entry("encryption", Map.ofEntries(
 *                     Map.entry("keySource", "Microsoft.KeyVault"),
 *                     Map.entry("keyVaultProperties", Map.ofEntries(
 *                         Map.entry("keyName", "KeyName"),
 *                         Map.entry("keyVaultUri", "https://pltfrmscrts-use-pc-dev.vault.azure.net/"),
 *                         Map.entry("keyVersion", "891CF236-D241-4738-9462-D506AF493DFA")
 *                     ))
 *                 )),
 *                 Map.entry("userOwnedStorage", Map.of("resourceId", "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "S0"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Account Min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var account = new AzureNative.CognitiveServices.Account("account", new()
 *     {
 *         AccountName = "testCreate1",
 *         Identity = new AzureNative.CognitiveServices.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.CognitiveServices.ResourceIdentityType.SystemAssigned,
 *         },
 *         Kind = "CognitiveServices",
 *         Location = "West US",
 *         Properties = null,
 *         ResourceGroupName = "myResourceGroup",
 *         Sku = new AzureNative.CognitiveServices.Inputs.SkuArgs
 *         {
 *             Name = "S0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewAccount(ctx, "account", &cognitiveservices.AccountArgs{
 * 			AccountName: pulumi.String("testCreate1"),
 * 			Identity: &cognitiveservices.IdentityArgs{
 * 				Type: cognitiveservices.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Kind:              pulumi.String("CognitiveServices"),
 * 			Location:          pulumi.String("West US"),
 * 			Properties:        nil,
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Sku: &cognitiveservices.SkuArgs{
 * 				Name: pulumi.String("S0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.Account;
 * import com.pulumi.azurenative.cognitiveservices.AccountArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var account = new Account("account", AccountArgs.builder()
 *             .accountName("testCreate1")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .kind("CognitiveServices")
 *             .location("West US")
 *             .properties()
 *             .resourceGroupName("myResourceGroup")
 *             .sku(Map.of("name", "S0"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:Account testCreate1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}
 * ```
 */
public class Account internal constructor(
    override val javaResource: com.pulumi.azurenative.cognitiveservices.Account,
) : KotlinCustomResource(javaResource, AccountMapper) {
    /**
     * Resource Etag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Kind of the resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of Cognitive Services account.
     */
    public val properties: Output<AccountPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                accountPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The resource model definition representing SKU
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AccountMapper : ResourceMapper<Account> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.cognitiveservices.Account::class == javaResource::class

    override fun map(javaResource: Resource): Account = Account(
        javaResource as
            com.pulumi.azurenative.cognitiveservices.Account,
    )
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Account].
 */
public suspend fun account(name: String, block: suspend AccountResourceBuilder.() -> Unit):
    Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Account].
 * @param name The _unique_ name of the resulting resource.
 */
public fun account(name: String): Account {
    val builder = AccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
