@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin

import com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiBlocklistItemPropertiesArgs
import com.pulumi.azurenative.cognitiveservices.kotlin.inputs.RaiBlocklistItemPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Cognitive Services RaiBlocklist Item.
 * Azure REST API version: 2023-10-01-preview.
 * ## Example Usage
 * ### PutRaiBlocklistItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var raiBlocklistItem = new AzureNative.CognitiveServices.RaiBlocklistItem("raiBlocklistItem", new()
 *     {
 *         AccountName = "accountName",
 *         Properties = new AzureNative.CognitiveServices.Inputs.RaiBlocklistItemPropertiesArgs
 *         {
 *             IsRegex = false,
 *             Pattern = "Pattern To Block",
 *         },
 *         RaiBlocklistItemName = "raiBlocklistItemName",
 *         RaiBlocklistName = "raiBlocklistName",
 *         ResourceGroupName = "resourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/cognitiveservices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := cognitiveservices.NewRaiBlocklistItem(ctx, "raiBlocklistItem", &cognitiveservices.RaiBlocklistItemArgs{
 * 			AccountName: pulumi.String("accountName"),
 * 			Properties: &cognitiveservices.RaiBlocklistItemPropertiesArgs{
 * 				IsRegex: pulumi.Bool(false),
 * 				Pattern: pulumi.String("Pattern To Block"),
 * 			},
 * 			RaiBlocklistItemName: pulumi.String("raiBlocklistItemName"),
 * 			RaiBlocklistName:     pulumi.String("raiBlocklistName"),
 * 			ResourceGroupName:    pulumi.String("resourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklistItem;
 * import com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var raiBlocklistItem = new RaiBlocklistItem("raiBlocklistItem", RaiBlocklistItemArgs.builder()
 *             .accountName("accountName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("isRegex", false),
 *                 Map.entry("pattern", "Pattern To Block")
 *             ))
 *             .raiBlocklistItemName("raiBlocklistItemName")
 *             .raiBlocklistName("raiBlocklistName")
 *             .resourceGroupName("resourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:cognitiveservices:RaiBlocklistItem raiBlocklistItemName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CognitiveServices/accounts/{accountName}/raiBlocklists/{raiBlocklistName}/raiBlocklistItems/{raiBlocklistItemName}
 * ```
 * @property accountName The name of Cognitive Services account.
 * @property properties Properties of Cognitive Services RaiBlocklist Item.
 * @property raiBlocklistItemName The name of the RaiBlocklist Item associated with the custom blocklist
 * @property raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class RaiBlocklistItemArgs(
    public val accountName: Output<String>? = null,
    public val properties: Output<RaiBlocklistItemPropertiesArgs>? = null,
    public val raiBlocklistItemName: Output<String>? = null,
    public val raiBlocklistName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs =
        com.pulumi.azurenative.cognitiveservices.RaiBlocklistItemArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .raiBlocklistItemName(raiBlocklistItemName?.applyValue({ args0 -> args0 }))
            .raiBlocklistName(raiBlocklistName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [RaiBlocklistItemArgs].
 */
@PulumiTagMarker
public class RaiBlocklistItemArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var properties: Output<RaiBlocklistItemPropertiesArgs>? = null

    private var raiBlocklistItemName: Output<String>? = null

    private var raiBlocklistName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("ckjoathwauqyfidl")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Properties of Cognitive Services RaiBlocklist Item.
     */
    @JvmName("bamsouktqiuasqfm")
    public suspend fun properties(`value`: Output<RaiBlocklistItemPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the RaiBlocklist Item associated with the custom blocklist
     */
    @JvmName("rqbwaaulcngmprsj")
    public suspend fun raiBlocklistItemName(`value`: Output<String>) {
        this.raiBlocklistItemName = value
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("qcwjvohldxeeqfps")
    public suspend fun raiBlocklistName(`value`: Output<String>) {
        this.raiBlocklistName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("twfhybiogjsvagby")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wnrdnvhyddnpmfsc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("gqxcwrnixihcovge")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Properties of Cognitive Services RaiBlocklist Item.
     */
    @JvmName("evemyxagxhfvhvlh")
    public suspend fun properties(`value`: RaiBlocklistItemPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of Cognitive Services RaiBlocklist Item.
     */
    @JvmName("gbbxxecblveeuqkn")
    public suspend
    fun properties(argument: suspend RaiBlocklistItemPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = RaiBlocklistItemPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the RaiBlocklist Item associated with the custom blocklist
     */
    @JvmName("ypncftiedkicxrah")
    public suspend fun raiBlocklistItemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistItemName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("vrjlgnpfdnncyrjr")
    public suspend fun raiBlocklistName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tshjwrpgrnpvnted")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rofqrxqigosyfawo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tvmoohiphpljwbsj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): RaiBlocklistItemArgs = RaiBlocklistItemArgs(
        accountName = accountName,
        properties = properties,
        raiBlocklistItemName = raiBlocklistItemName,
        raiBlocklistName = raiBlocklistName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
