@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property commitmentPlanAssociationName The name of the commitment plan association with the Cognitive Services Account
 * @property commitmentPlanName The name of the commitmentPlan associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCommitmentPlanAssociationPlainArgs(
    public val commitmentPlanAssociationName: String,
    public val commitmentPlanName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanAssociationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanAssociationPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetCommitmentPlanAssociationPlainArgs.builder()
            .commitmentPlanAssociationName(commitmentPlanAssociationName.let({ args0 -> args0 }))
            .commitmentPlanName(commitmentPlanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommitmentPlanAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetCommitmentPlanAssociationPlainArgsBuilder internal constructor() {
    private var commitmentPlanAssociationName: String? = null

    private var commitmentPlanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the commitment plan association with the Cognitive Services Account
     */
    @JvmName("msxfprbgfioraqrd")
    public suspend fun commitmentPlanAssociationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commitmentPlanAssociationName = mapped
    }

    /**
     * @param value The name of the commitmentPlan associated with the Cognitive Services Account
     */
    @JvmName("wepcajustnqkilnu")
    public suspend fun commitmentPlanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.commitmentPlanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("udbpvlbfhtkqpvsm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCommitmentPlanAssociationPlainArgs =
        GetCommitmentPlanAssociationPlainArgs(
            commitmentPlanAssociationName = commitmentPlanAssociationName ?: throw
                PulumiNullFieldException("commitmentPlanAssociationName"),
            commitmentPlanName = commitmentPlanName ?: throw PulumiNullFieldException("commitmentPlanName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
