@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of Cognitive Services account.
 * @property raiBlocklistItemName The name of the RaiBlocklist Item associated with the custom blocklist
 * @property raiBlocklistName The name of the RaiBlocklist associated with the Cognitive Services Account
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetRaiBlocklistItemPlainArgs(
    public val accountName: String,
    public val raiBlocklistItemName: String,
    public val raiBlocklistName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistItemPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistItemPlainArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.GetRaiBlocklistItemPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .raiBlocklistItemName(raiBlocklistItemName.let({ args0 -> args0 }))
            .raiBlocklistName(raiBlocklistName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRaiBlocklistItemPlainArgs].
 */
@PulumiTagMarker
public class GetRaiBlocklistItemPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var raiBlocklistItemName: String? = null

    private var raiBlocklistName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of Cognitive Services account.
     */
    @JvmName("iwvvpcluwhcekyyt")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist Item associated with the custom blocklist
     */
    @JvmName("fyjflphldryubmqb")
    public suspend fun raiBlocklistItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiBlocklistItemName = mapped
    }

    /**
     * @param value The name of the RaiBlocklist associated with the Cognitive Services Account
     */
    @JvmName("lvyftbypnfruiqpq")
    public suspend fun raiBlocklistName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.raiBlocklistName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qfvfkpcqgwbjphoc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetRaiBlocklistItemPlainArgs = GetRaiBlocklistItemPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        raiBlocklistItemName = raiBlocklistItemName ?: throw
            PulumiNullFieldException("raiBlocklistItemName"),
        raiBlocklistName = raiBlocklistName ?: throw PulumiNullFieldException("raiBlocklistName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
