@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.inputs

import com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs.builder
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.AllowedContentLevel
import com.pulumi.azurenative.cognitiveservices.kotlin.enums.RaiPolicyContentSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure OpenAI Content Filter.
 * @property allowedContentLevel Level at which content is filtered.
 * @property blocking If blocking would occur.
 * @property enabled If the ContentFilter is enabled.
 * @property policyName Name of ContentFilter.
 * @property source Content source to apply the Content Filters.
 */
public data class RaiPolicyContentFilterArgs(
    public val allowedContentLevel: Output<Either<String, AllowedContentLevel>>? = null,
    public val blocking: Output<Boolean>? = null,
    public val enabled: Output<Boolean>? = null,
    public val policyName: Output<String>? = null,
    public val source: Output<Either<String, RaiPolicyContentSource>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs =
        com.pulumi.azurenative.cognitiveservices.inputs.RaiPolicyContentFilterArgs.builder()
            .allowedContentLevel(
                allowedContentLevel?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .blocking(blocking?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RaiPolicyContentFilterArgs].
 */
@PulumiTagMarker
public class RaiPolicyContentFilterArgsBuilder internal constructor() {
    private var allowedContentLevel: Output<Either<String, AllowedContentLevel>>? = null

    private var blocking: Output<Boolean>? = null

    private var enabled: Output<Boolean>? = null

    private var policyName: Output<String>? = null

    private var source: Output<Either<String, RaiPolicyContentSource>>? = null

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("rfumobxkralktiub")
    public suspend fun allowedContentLevel(`value`: Output<Either<String, AllowedContentLevel>>) {
        this.allowedContentLevel = value
    }

    /**
     * @param value If blocking would occur.
     */
    @JvmName("trywlnpvdxhkuvcg")
    public suspend fun blocking(`value`: Output<Boolean>) {
        this.blocking = value
    }

    /**
     * @param value If the ContentFilter is enabled.
     */
    @JvmName("vyabgfvocpumbgsm")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("qonflmmbeydwtwye")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("ipbwgwysjetyinyb")
    public suspend fun source(`value`: Output<Either<String, RaiPolicyContentSource>>) {
        this.source = value
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("vjbodajjgrcptjie")
    public suspend fun allowedContentLevel(`value`: Either<String, AllowedContentLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("jdndhvohujjsqvmd")
    public fun allowedContentLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AllowedContentLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value Level at which content is filtered.
     */
    @JvmName("twvcagkmrvxtxjxk")
    public fun allowedContentLevel(`value`: AllowedContentLevel) {
        val toBeMapped = Either.ofRight<String, AllowedContentLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedContentLevel = mapped
    }

    /**
     * @param value If blocking would occur.
     */
    @JvmName("ysotveeliwgtybas")
    public suspend fun blocking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blocking = mapped
    }

    /**
     * @param value If the ContentFilter is enabled.
     */
    @JvmName("myydmmrvbmsrjrdj")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Name of ContentFilter.
     */
    @JvmName("beyxcajbglbklhbb")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("ifhhqvxcoaxjuhxf")
    public suspend fun source(`value`: Either<String, RaiPolicyContentSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("veuxqkmgntnjydrh")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RaiPolicyContentSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Content source to apply the Content Filters.
     */
    @JvmName("yfutwboowgjxaofp")
    public fun source(`value`: RaiPolicyContentSource) {
        val toBeMapped = Either.ofRight<String, RaiPolicyContentSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): RaiPolicyContentFilterArgs = RaiPolicyContentFilterArgs(
        allowedContentLevel = allowedContentLevel,
        blocking = blocking,
        enabled = enabled,
        policyName = policyName,
        source = source,
    )
}
