@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Azure OpenAI Content Filter.
 * @property allowedContentLevel Level at which content is filtered.
 * @property blocking If blocking would occur.
 * @property enabled If the ContentFilter is enabled.
 * @property policyName Name of ContentFilter.
 * @property source Content source to apply the Content Filters.
 */
public data class RaiPolicyContentFilterResponse(
    public val allowedContentLevel: String? = null,
    public val blocking: Boolean? = null,
    public val enabled: Boolean? = null,
    public val policyName: String? = null,
    public val source: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.RaiPolicyContentFilterResponse):
            RaiPolicyContentFilterResponse = RaiPolicyContentFilterResponse(
            allowedContentLevel = javaType.allowedContentLevel().map({ args0 -> args0 }).orElse(null),
            blocking = javaType.blocking().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            policyName = javaType.policyName().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
        )
    }
}
