@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.cognitiveservices.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Sku change info of account.
 * @property countOfDowngrades Gets the count of downgrades.
 * @property countOfUpgradesAfterDowngrades Gets the count of upgrades after downgrades.
 * @property lastChangeDate Gets the last change date.
 */
public data class SkuChangeInfoResponse(
    public val countOfDowngrades: Double? = null,
    public val countOfUpgradesAfterDowngrades: Double? = null,
    public val lastChangeDate: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.cognitiveservices.outputs.SkuChangeInfoResponse):
            SkuChangeInfoResponse = SkuChangeInfoResponse(
            countOfDowngrades = javaType.countOfDowngrades().map({ args0 -> args0 }).orElse(null),
            countOfUpgradesAfterDowngrades = javaType.countOfUpgradesAfterDowngrades().map({ args0 ->
                args0
            }).orElse(null),
            lastChangeDate = javaType.lastChangeDate().map({ args0 -> args0 }).orElse(null),
        )
    }
}
