@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.DomainArgs.builder
import com.pulumi.azurenative.communication.kotlin.enums.DomainManagement
import com.pulumi.azurenative.communication.kotlin.enums.UserEngagementTracking
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class representing a Domains resource.
 * Azure REST API version: 2023-03-31. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2022-07-01-preview, 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update Domains resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.Communication.Domain("domain", new()
 *     {
 *         DomainManagement = "CustomerManaged",
 *         DomainName = "mydomain.com",
 *         EmailServiceName = "MyEmailServiceResource",
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewDomain(ctx, "domain", &communication.DomainArgs{
 * 			DomainManagement:  pulumi.String("CustomerManaged"),
 * 			DomainName:        pulumi.String("mydomain.com"),
 * 			EmailServiceName:  pulumi.String("MyEmailServiceResource"),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.Domain;
 * import com.pulumi.azurenative.communication.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .domainManagement("CustomerManaged")
 *             .domainName("mydomain.com")
 *             .emailServiceName("MyEmailServiceResource")
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:Domain mydomain.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}
 * ```
 * @property domainManagement Describes how a Domains resource is being managed.
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property userEngagementTracking Describes whether user engagement tracking is enabled or disabled.
 */
public data class DomainArgs(
    public val domainManagement: Output<Either<String, DomainManagement>>? = null,
    public val domainName: Output<String>? = null,
    public val emailServiceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userEngagementTracking: Output<Either<String, UserEngagementTracking>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.DomainArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.DomainArgs =
        com.pulumi.azurenative.communication.DomainArgs.builder()
            .domainManagement(
                domainManagement?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .domainName(domainName?.applyValue({ args0 -> args0 }))
            .emailServiceName(emailServiceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userEngagementTracking(
                userEngagementTracking?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [DomainArgs].
 */
@PulumiTagMarker
public class DomainArgsBuilder internal constructor() {
    private var domainManagement: Output<Either<String, DomainManagement>>? = null

    private var domainName: Output<String>? = null

    private var emailServiceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userEngagementTracking: Output<Either<String, UserEngagementTracking>>? = null

    /**
     * @param value Describes how a Domains resource is being managed.
     */
    @JvmName("ducktwamlajqpwdi")
    public suspend fun domainManagement(`value`: Output<Either<String, DomainManagement>>) {
        this.domainManagement = value
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("kdbgcpentflmilxn")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("edsjaqjjstquydth")
    public suspend fun emailServiceName(`value`: Output<String>) {
        this.emailServiceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rwccgdnstxuplvft")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("abjaiccvdhfwvsww")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gfhcnfaxwglnvapo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes whether user engagement tracking is enabled or disabled.
     */
    @JvmName("uikwltpyhsbdkxbo")
    public suspend
    fun userEngagementTracking(`value`: Output<Either<String, UserEngagementTracking>>) {
        this.userEngagementTracking = value
    }

    /**
     * @param value Describes how a Domains resource is being managed.
     */
    @JvmName("dxmtdjhdxlguafse")
    public suspend fun domainManagement(`value`: Either<String, DomainManagement>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainManagement = mapped
    }

    /**
     * @param value Describes how a Domains resource is being managed.
     */
    @JvmName("atxgnhgyslfnshvo")
    public fun domainManagement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DomainManagement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainManagement = mapped
    }

    /**
     * @param value Describes how a Domains resource is being managed.
     */
    @JvmName("wwdbktknjjwuxxiq")
    public fun domainManagement(`value`: DomainManagement) {
        val toBeMapped = Either.ofRight<String, DomainManagement>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainManagement = mapped
    }

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("ouarhtmfrtqajeoy")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("rpltfujqthveqpqc")
    public suspend fun emailServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailServiceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bmbcvwjajhqctlfd")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qhjkexaexbamujpa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iuiwsphlkkiobull")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qdcfqibnagnwgugq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Describes whether user engagement tracking is enabled or disabled.
     */
    @JvmName("bfdffmejorbultkk")
    public suspend fun userEngagementTracking(`value`: Either<String, UserEngagementTracking>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userEngagementTracking = mapped
    }

    /**
     * @param value Describes whether user engagement tracking is enabled or disabled.
     */
    @JvmName("ptjqecmehttqhnxd")
    public fun userEngagementTracking(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UserEngagementTracking>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userEngagementTracking = mapped
    }

    /**
     * @param value Describes whether user engagement tracking is enabled or disabled.
     */
    @JvmName("xpjudvaifodfwhbw")
    public fun userEngagementTracking(`value`: UserEngagementTracking) {
        val toBeMapped = Either.ofRight<String, UserEngagementTracking>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userEngagementTracking = mapped
    }

    internal fun build(): DomainArgs = DomainArgs(
        domainManagement = domainManagement,
        domainName = domainName,
        emailServiceName = emailServiceName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userEngagementTracking = userEngagementTracking,
    )
}
