@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin

import com.pulumi.azurenative.communication.EmailServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A class representing an EmailService resource.
 * Azure REST API version: 2023-03-31. Prior API version in Azure Native 1.x: 2021-10-01-preview.
 * Other available API versions: 2023-04-01, 2023-04-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Create or update EmailService resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var emailService = new AzureNative.Communication.EmailService("emailService", new()
 *     {
 *         DataLocation = "United States",
 *         EmailServiceName = "MyEmailServiceResource",
 *         Location = "Global",
 *         ResourceGroupName = "MyResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/communication/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := communication.NewEmailService(ctx, "emailService", &communication.EmailServiceArgs{
 * 			DataLocation:      pulumi.String("United States"),
 * 			EmailServiceName:  pulumi.String("MyEmailServiceResource"),
 * 			Location:          pulumi.String("Global"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.communication.EmailService;
 * import com.pulumi.azurenative.communication.EmailServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var emailService = new EmailService("emailService", EmailServiceArgs.builder()
 *             .dataLocation("United States")
 *             .emailServiceName("MyEmailServiceResource")
 *             .location("Global")
 *             .resourceGroupName("MyResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:communication:EmailService MyEmailServiceResource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}
 * ```
 * @property dataLocation The location where the email service stores its data at rest.
 * @property emailServiceName The name of the EmailService resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class EmailServiceArgs(
    public val dataLocation: Output<String>? = null,
    public val emailServiceName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.communication.EmailServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.EmailServiceArgs =
        com.pulumi.azurenative.communication.EmailServiceArgs.builder()
            .dataLocation(dataLocation?.applyValue({ args0 -> args0 }))
            .emailServiceName(emailServiceName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EmailServiceArgs].
 */
@PulumiTagMarker
public class EmailServiceArgsBuilder internal constructor() {
    private var dataLocation: Output<String>? = null

    private var emailServiceName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The location where the email service stores its data at rest.
     */
    @JvmName("ivwviwlfbyfrpmgs")
    public suspend fun dataLocation(`value`: Output<String>) {
        this.dataLocation = value
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("qtnfekegqpcscvfb")
    public suspend fun emailServiceName(`value`: Output<String>) {
        this.emailServiceName = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ygkuemmifwepwaui")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ugtsvdgihyjqsyps")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pbnixerllworwvnr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The location where the email service stores its data at rest.
     */
    @JvmName("kwdqblidpsehgtpr")
    public suspend fun dataLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataLocation = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("wqaodlicrmcyknda")
    public suspend fun emailServiceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailServiceName = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("yqucfytmqjirkscg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pmvbmqinhkbotcur")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nvfbuckimfvwpnla")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nariymlsvkhbvlok")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EmailServiceArgs = EmailServiceArgs(
        dataLocation = dataLocation,
        emailServiceName = emailServiceName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
