@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.GetDomainPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property domainName The name of the Domains resource.
 * @property emailServiceName The name of the EmailService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDomainPlainArgs(
    public val domainName: String,
    public val emailServiceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.communication.inputs.GetDomainPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.communication.inputs.GetDomainPlainArgs =
        com.pulumi.azurenative.communication.inputs.GetDomainPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .emailServiceName(emailServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainPlainArgs].
 */
@PulumiTagMarker
public class GetDomainPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var emailServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Domains resource.
     */
    @JvmName("yrcxgwcaiskedwen")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value The name of the EmailService resource.
     */
    @JvmName("iwoqydyqdarrhsvx")
    public suspend fun emailServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.emailServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("webdohubwkoehvri")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDomainPlainArgs = GetDomainPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        emailServiceName = emailServiceName ?: throw PulumiNullFieldException("emailServiceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
