@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.inputs

import com.pulumi.azurenative.communication.inputs.ListCommunicationServiceKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communicationServiceName The name of the CommunicationService resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ListCommunicationServiceKeysPlainArgs(
    public val communicationServiceName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.communication.inputs.ListCommunicationServiceKeysPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.communication.inputs.ListCommunicationServiceKeysPlainArgs =
        com.pulumi.azurenative.communication.inputs.ListCommunicationServiceKeysPlainArgs.builder()
            .communicationServiceName(communicationServiceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListCommunicationServiceKeysPlainArgs].
 */
@PulumiTagMarker
public class ListCommunicationServiceKeysPlainArgsBuilder internal constructor() {
    private var communicationServiceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the CommunicationService resource.
     */
    @JvmName("uvixetfqqytxpswc")
    public suspend fun communicationServiceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communicationServiceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xgvpfbjngagjkbni")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListCommunicationServiceKeysPlainArgs =
        ListCommunicationServiceKeysPlainArgs(
            communicationServiceName = communicationServiceName ?: throw
                PulumiNullFieldException("communicationServiceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
