@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A class that represents a VerificationStatus record.
 * @property name Name of the DNS record.
 * @property ttl Represents an expiry time in seconds to represent how long this entry can be cached by the resolver, default = 3600sec.
 * @property type Type of the DNS record. Example: TXT
 * @property value Value of the DNS record.
 */
public data class DnsRecordResponse(
    public val name: String,
    public val ttl: Int,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.DnsRecordResponse):
            DnsRecordResponse = DnsRecordResponse(
            name = javaType.name(),
            ttl = javaType.ttl(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
