@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.communication.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A class representing a SenderUsername resource.
 * @property dataLocation The location where the SenderUsername resource data is stored at rest.
 * @property displayName The display name for the senderUsername.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the resource. Unknown is the default state for Communication Services.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property username A sender senderUsername to be used when sending emails.
 */
public data class GetSenderUsernameResult(
    public val dataLocation: String,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val username: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.communication.outputs.GetSenderUsernameResult):
            GetSenderUsernameResult = GetSenderUsernameResult(
            dataLocation = javaType.dataLocation(),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.communication.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            username = javaType.username(),
        )
    }
}
