@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin

import com.pulumi.azurenative.community.CommunityTrainingArgs.builder
import com.pulumi.azurenative.community.kotlin.inputs.IdentityConfigurationPropertiesArgs
import com.pulumi.azurenative.community.kotlin.inputs.IdentityConfigurationPropertiesArgsBuilder
import com.pulumi.azurenative.community.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.community.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A CommunityProviderHub resource
 * Azure REST API version: 2023-11-01.
 * ## Example Usage
 * ### CreateCommunityTrainings
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var communityTraining = new AzureNative.Community.CommunityTraining("communityTraining", new()
 *     {
 *         CommunityTrainingName = "ctApplication",
 *         DisasterRecoveryEnabled = true,
 *         IdentityConfiguration = new AzureNative.Community.Inputs.IdentityConfigurationPropertiesArgs
 *         {
 *             B2cAuthenticationPolicy = "B2C_1_signup_signin",
 *             B2cPasswordResetPolicy = "B2C_1_pwd_reset",
 *             ClientId = "8c92390f-2f30-493d-bd13-d3c3eba3709d",
 *             ClientSecret = "idenityConfigurationClientSecret",
 *             CustomLoginParameters = "custom_hint",
 *             DomainName = "cttenant",
 *             IdentityType = "ADB2C",
 *             TeamsEnabled = false,
 *             TenantId = "c1ffbb60-88cf-4b83-b54f-c47ae6220c19",
 *         },
 *         Location = "southeastasia",
 *         PortalAdminEmailAddress = "ctadmin@ct.com",
 *         PortalName = "ctwebsite",
 *         PortalOwnerEmailAddress = "ctcontact@ct.com",
 *         PortalOwnerOrganizationName = "CT Portal Owner Organization",
 *         ResourceGroupName = "rgCommunityTaining",
 *         Sku = new AzureNative.Community.Inputs.SkuArgs
 *         {
 *             Name = "Commercial",
 *             Tier = AzureNative.Community.SkuTier.Standard,
 *         },
 *         ZoneRedundancyEnabled = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/community/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := community.NewCommunityTraining(ctx, "communityTraining", &community.CommunityTrainingArgs{
 * 			CommunityTrainingName:   pulumi.String("ctApplication"),
 * 			DisasterRecoveryEnabled: pulumi.Bool(true),
 * 			IdentityConfiguration: &community.IdentityConfigurationPropertiesArgs{
 * 				B2cAuthenticationPolicy: pulumi.String("B2C_1_signup_signin"),
 * 				B2cPasswordResetPolicy:  pulumi.String("B2C_1_pwd_reset"),
 * 				ClientId:                pulumi.String("8c92390f-2f30-493d-bd13-d3c3eba3709d"),
 * 				ClientSecret:            pulumi.String("idenityConfigurationClientSecret"),
 * 				CustomLoginParameters:   pulumi.String("custom_hint"),
 * 				DomainName:              pulumi.String("cttenant"),
 * 				IdentityType:            pulumi.String("ADB2C"),
 * 				TeamsEnabled:            pulumi.Bool(false),
 * 				TenantId:                pulumi.String("c1ffbb60-88cf-4b83-b54f-c47ae6220c19"),
 * 			},
 * 			Location:                    pulumi.String("southeastasia"),
 * 			PortalAdminEmailAddress:     pulumi.String("ctadmin@ct.com"),
 * 			PortalName:                  pulumi.String("ctwebsite"),
 * 			PortalOwnerEmailAddress:     pulumi.String("ctcontact@ct.com"),
 * 			PortalOwnerOrganizationName: pulumi.String("CT Portal Owner Organization"),
 * 			ResourceGroupName:           pulumi.String("rgCommunityTaining"),
 * 			Sku: &community.SkuArgs{
 * 				Name: pulumi.String("Commercial"),
 * 				Tier: community.SkuTierStandard,
 * 			},
 * 			ZoneRedundancyEnabled: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.community.CommunityTraining;
 * import com.pulumi.azurenative.community.CommunityTrainingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var communityTraining = new CommunityTraining("communityTraining", CommunityTrainingArgs.builder()
 *             .communityTrainingName("ctApplication")
 *             .disasterRecoveryEnabled(true)
 *             .identityConfiguration(Map.ofEntries(
 *                 Map.entry("b2cAuthenticationPolicy", "B2C_1_signup_signin"),
 *                 Map.entry("b2cPasswordResetPolicy", "B2C_1_pwd_reset"),
 *                 Map.entry("clientId", "8c92390f-2f30-493d-bd13-d3c3eba3709d"),
 *                 Map.entry("clientSecret", "idenityConfigurationClientSecret"),
 *                 Map.entry("customLoginParameters", "custom_hint"),
 *                 Map.entry("domainName", "cttenant"),
 *                 Map.entry("identityType", "ADB2C"),
 *                 Map.entry("teamsEnabled", false),
 *                 Map.entry("tenantId", "c1ffbb60-88cf-4b83-b54f-c47ae6220c19")
 *             ))
 *             .location("southeastasia")
 *             .portalAdminEmailAddress("ctadmin@ct.com")
 *             .portalName("ctwebsite")
 *             .portalOwnerEmailAddress("ctcontact@ct.com")
 *             .portalOwnerOrganizationName("CT Portal Owner Organization")
 *             .resourceGroupName("rgCommunityTaining")
 *             .sku(Map.ofEntries(
 *                 Map.entry("name", "Commercial"),
 *                 Map.entry("tier", "Standard")
 *             ))
 *             .zoneRedundancyEnabled(true)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:community:CommunityTraining ctApplication /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Community/communityTrainings/{communityTrainingName}
 * ```
 * @property communityTrainingName The name of the Community Training Resource
 * @property disasterRecoveryEnabled To indicate whether the Community Training instance has Disaster Recovery enabled
 * @property identityConfiguration The identity configuration of the Community Training resource
 * @property location The geo-location where the resource lives
 * @property portalAdminEmailAddress The email address of the portal admin
 * @property portalName The portal name (website name) of the Community Training instance
 * @property portalOwnerEmailAddress The email address of the portal owner. Will be used as the primary contact
 * @property portalOwnerOrganizationName The organization name of the portal owner
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU (Stock Keeping Unit) assigned to this resource.
 * @property tags Resource tags.
 * @property zoneRedundancyEnabled To indicate whether the Community Training instance has Zone Redundancy enabled
 */
public data class CommunityTrainingArgs(
    public val communityTrainingName: Output<String>? = null,
    public val disasterRecoveryEnabled: Output<Boolean>? = null,
    public val identityConfiguration: Output<IdentityConfigurationPropertiesArgs>? = null,
    public val location: Output<String>? = null,
    public val portalAdminEmailAddress: Output<String>? = null,
    public val portalName: Output<String>? = null,
    public val portalOwnerEmailAddress: Output<String>? = null,
    public val portalOwnerOrganizationName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val zoneRedundancyEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.community.CommunityTrainingArgs> {
    override fun toJava(): com.pulumi.azurenative.community.CommunityTrainingArgs =
        com.pulumi.azurenative.community.CommunityTrainingArgs.builder()
            .communityTrainingName(communityTrainingName?.applyValue({ args0 -> args0 }))
            .disasterRecoveryEnabled(disasterRecoveryEnabled?.applyValue({ args0 -> args0 }))
            .identityConfiguration(
                identityConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .portalAdminEmailAddress(portalAdminEmailAddress?.applyValue({ args0 -> args0 }))
            .portalName(portalName?.applyValue({ args0 -> args0 }))
            .portalOwnerEmailAddress(portalOwnerEmailAddress?.applyValue({ args0 -> args0 }))
            .portalOwnerOrganizationName(portalOwnerOrganizationName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .zoneRedundancyEnabled(zoneRedundancyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommunityTrainingArgs].
 */
@PulumiTagMarker
public class CommunityTrainingArgsBuilder internal constructor() {
    private var communityTrainingName: Output<String>? = null

    private var disasterRecoveryEnabled: Output<Boolean>? = null

    private var identityConfiguration: Output<IdentityConfigurationPropertiesArgs>? = null

    private var location: Output<String>? = null

    private var portalAdminEmailAddress: Output<String>? = null

    private var portalName: Output<String>? = null

    private var portalOwnerEmailAddress: Output<String>? = null

    private var portalOwnerOrganizationName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var zoneRedundancyEnabled: Output<Boolean>? = null

    /**
     * @param value The name of the Community Training Resource
     */
    @JvmName("abkmjhpekumcbocm")
    public suspend fun communityTrainingName(`value`: Output<String>) {
        this.communityTrainingName = value
    }

    /**
     * @param value To indicate whether the Community Training instance has Disaster Recovery enabled
     */
    @JvmName("bpmpukxtycitypww")
    public suspend fun disasterRecoveryEnabled(`value`: Output<Boolean>) {
        this.disasterRecoveryEnabled = value
    }

    /**
     * @param value The identity configuration of the Community Training resource
     */
    @JvmName("ygwdfjjmghymafxg")
    public suspend fun identityConfiguration(`value`: Output<IdentityConfigurationPropertiesArgs>) {
        this.identityConfiguration = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wxepodwebpadcxrs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The email address of the portal admin
     */
    @JvmName("tskguvokvqbiqawv")
    public suspend fun portalAdminEmailAddress(`value`: Output<String>) {
        this.portalAdminEmailAddress = value
    }

    /**
     * @param value The portal name (website name) of the Community Training instance
     */
    @JvmName("lmylahsilmyowrxs")
    public suspend fun portalName(`value`: Output<String>) {
        this.portalName = value
    }

    /**
     * @param value The email address of the portal owner. Will be used as the primary contact
     */
    @JvmName("muiocknypyghrfqx")
    public suspend fun portalOwnerEmailAddress(`value`: Output<String>) {
        this.portalOwnerEmailAddress = value
    }

    /**
     * @param value The organization name of the portal owner
     */
    @JvmName("ynuwrakafqpsetni")
    public suspend fun portalOwnerOrganizationName(`value`: Output<String>) {
        this.portalOwnerOrganizationName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qkaddneraoitjvfo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU (Stock Keeping Unit) assigned to this resource.
     */
    @JvmName("crpckkeuicqrigim")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uksrvvtjftsnecbp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value To indicate whether the Community Training instance has Zone Redundancy enabled
     */
    @JvmName("lbajnkogbwupmgsy")
    public suspend fun zoneRedundancyEnabled(`value`: Output<Boolean>) {
        this.zoneRedundancyEnabled = value
    }

    /**
     * @param value The name of the Community Training Resource
     */
    @JvmName("cnspijwaqavxlqqc")
    public suspend fun communityTrainingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityTrainingName = mapped
    }

    /**
     * @param value To indicate whether the Community Training instance has Disaster Recovery enabled
     */
    @JvmName("filmlxbcpaebbpjk")
    public suspend fun disasterRecoveryEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disasterRecoveryEnabled = mapped
    }

    /**
     * @param value The identity configuration of the Community Training resource
     */
    @JvmName("dsmjvloqdtfgildu")
    public suspend fun identityConfiguration(`value`: IdentityConfigurationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityConfiguration = mapped
    }

    /**
     * @param argument The identity configuration of the Community Training resource
     */
    @JvmName("jahxxedlhpglexol")
    public suspend
    fun identityConfiguration(argument: suspend IdentityConfigurationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityConfigurationPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityConfiguration = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tdrknssituooriyu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The email address of the portal admin
     */
    @JvmName("dmhjngimpxuiakwp")
    public suspend fun portalAdminEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalAdminEmailAddress = mapped
    }

    /**
     * @param value The portal name (website name) of the Community Training instance
     */
    @JvmName("tfathjknlgxinpte")
    public suspend fun portalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalName = mapped
    }

    /**
     * @param value The email address of the portal owner. Will be used as the primary contact
     */
    @JvmName("oflrngrukqfjdpfc")
    public suspend fun portalOwnerEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalOwnerEmailAddress = mapped
    }

    /**
     * @param value The organization name of the portal owner
     */
    @JvmName("iulbywbphnfgexmj")
    public suspend fun portalOwnerOrganizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalOwnerOrganizationName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ahcxeohejspiwjvg")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU (Stock Keeping Unit) assigned to this resource.
     */
    @JvmName("uyxnipqljkflbjym")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU (Stock Keeping Unit) assigned to this resource.
     */
    @JvmName("kxdckjywukrlutrv")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nmyjfdnumuhwbamv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nkifgcqbwiowyxvp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value To indicate whether the Community Training instance has Zone Redundancy enabled
     */
    @JvmName("rqnfhsfdwxevqlbe")
    public suspend fun zoneRedundancyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancyEnabled = mapped
    }

    internal fun build(): CommunityTrainingArgs = CommunityTrainingArgs(
        communityTrainingName = communityTrainingName,
        disasterRecoveryEnabled = disasterRecoveryEnabled,
        identityConfiguration = identityConfiguration,
        location = location,
        portalAdminEmailAddress = portalAdminEmailAddress,
        portalName = portalName,
        portalOwnerEmailAddress = portalOwnerEmailAddress,
        portalOwnerOrganizationName = portalOwnerOrganizationName,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        zoneRedundancyEnabled = zoneRedundancyEnabled,
    )
}
