@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.community.kotlin.inputs

import com.pulumi.azurenative.community.inputs.GetCommunityTrainingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communityTrainingName The name of the Community Training Resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCommunityTrainingPlainArgs(
    public val communityTrainingName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.community.inputs.GetCommunityTrainingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.community.inputs.GetCommunityTrainingPlainArgs =
        com.pulumi.azurenative.community.inputs.GetCommunityTrainingPlainArgs.builder()
            .communityTrainingName(communityTrainingName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCommunityTrainingPlainArgs].
 */
@PulumiTagMarker
public class GetCommunityTrainingPlainArgsBuilder internal constructor() {
    private var communityTrainingName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Community Training Resource
     */
    @JvmName("vinxvyfablgrajhm")
    public suspend fun communityTrainingName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communityTrainingName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("mvjscegaauxgxcvw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCommunityTrainingPlainArgs = GetCommunityTrainingPlainArgs(
        communityTrainingName = communityTrainingName ?: throw
            PulumiNullFieldException("communityTrainingName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
