@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.AvailabilitySetArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SkuArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.SubResourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see [Availability sets overview](https://docs&#46;microsoft&#46;com/azure/virtual-machines/availability-set-overview)&#46; For more information on Azure planned maintenance, see [Maintenance and updates for Virtual Machines in Azure](https://docs.microsoft.com/azure/virtual-machines/maintenance-and-updates). Currently, a VM can only be added to an availability set at creation time. An existing VM cannot be added to an availability set.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2023-07-01.
 * ## Example Usage
 * ### Create an availability set.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var availabilitySet = new AzureNative.Compute.AvailabilitySet("availabilitySet", new()
 *     {
 *         AvailabilitySetName = "myAvailabilitySet",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 2,
 *         PlatformUpdateDomainCount = 20,
 *         ResourceGroupName = "myResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewAvailabilitySet(ctx, "availabilitySet", &compute.AvailabilitySetArgs{
 * 			AvailabilitySetName:       pulumi.String("myAvailabilitySet"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(2),
 * 			PlatformUpdateDomainCount: pulumi.Int(20),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.AvailabilitySet;
 * import com.pulumi.azurenative.compute.AvailabilitySetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var availabilitySet = new AvailabilitySet("availabilitySet", AvailabilitySetArgs.builder()
 *             .availabilitySetName("myAvailabilitySet")
 *             .location("westus")
 *             .platformFaultDomainCount(2)
 *             .platformUpdateDomainCount(20)
 *             .resourceGroupName("myResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:AvailabilitySet myAvailabilitySet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}
 * ```
 * @property availabilitySetName The name of the availability set.
 * @property location Resource location
 * @property platformFaultDomainCount Fault Domain count.
 * @property platformUpdateDomainCount Update Domain count.
 * @property proximityPlacementGroup Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
 * @property resourceGroupName The name of the resource group.
 * @property sku Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
 * @property tags Resource tags
 * @property virtualMachines A list of references to all virtual machines in the availability set.
 */
public data class AvailabilitySetArgs(
    public val availabilitySetName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val platformFaultDomainCount: Output<Int>? = null,
    public val platformUpdateDomainCount: Output<Int>? = null,
    public val proximityPlacementGroup: Output<SubResourceArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMachines: Output<List<SubResourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.AvailabilitySetArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.AvailabilitySetArgs =
        com.pulumi.azurenative.compute.AvailabilitySetArgs.builder()
            .availabilitySetName(availabilitySetName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .platformFaultDomainCount(platformFaultDomainCount?.applyValue({ args0 -> args0 }))
            .platformUpdateDomainCount(platformUpdateDomainCount?.applyValue({ args0 -> args0 }))
            .proximityPlacementGroup(
                proximityPlacementGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMachines(
                virtualMachines?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AvailabilitySetArgs].
 */
@PulumiTagMarker
public class AvailabilitySetArgsBuilder internal constructor() {
    private var availabilitySetName: Output<String>? = null

    private var location: Output<String>? = null

    private var platformFaultDomainCount: Output<Int>? = null

    private var platformUpdateDomainCount: Output<Int>? = null

    private var proximityPlacementGroup: Output<SubResourceArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMachines: Output<List<SubResourceArgs>>? = null

    /**
     * @param value The name of the availability set.
     */
    @JvmName("gjuvdfjyrngavhpd")
    public suspend fun availabilitySetName(`value`: Output<String>) {
        this.availabilitySetName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("shwpshkldmlmiibt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Fault Domain count.
     */
    @JvmName("eisdywsmynvuboxc")
    public suspend fun platformFaultDomainCount(`value`: Output<Int>) {
        this.platformFaultDomainCount = value
    }

    /**
     * @param value Update Domain count.
     */
    @JvmName("vsxjvsphfpnbeipf")
    public suspend fun platformUpdateDomainCount(`value`: Output<Int>) {
        this.platformUpdateDomainCount = value
    }

    /**
     * @param value Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("kfgghuftnjkuhocc")
    public suspend fun proximityPlacementGroup(`value`: Output<SubResourceArgs>) {
        this.proximityPlacementGroup = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("eaxtlbfavlktcexn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
     */
    @JvmName("pkrhxhmpkoofqqbn")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("qmyqmffchejimdmm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of references to all virtual machines in the availability set.
     */
    @JvmName("ekwlfbatxoywflfj")
    public suspend fun virtualMachines(`value`: Output<List<SubResourceArgs>>) {
        this.virtualMachines = value
    }

    @JvmName("jtcdkunbgcmrqloy")
    public suspend fun virtualMachines(vararg values: Output<SubResourceArgs>) {
        this.virtualMachines = Output.all(values.asList())
    }

    /**
     * @param values A list of references to all virtual machines in the availability set.
     */
    @JvmName("tusinxjisibxndol")
    public suspend fun virtualMachines(values: List<Output<SubResourceArgs>>) {
        this.virtualMachines = Output.all(values)
    }

    /**
     * @param value The name of the availability set.
     */
    @JvmName("vpochdhbblkgmvlt")
    public suspend fun availabilitySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilitySetName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("qkessolhhgfwponp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Fault Domain count.
     */
    @JvmName("ucsguprrufyvinmg")
    public suspend fun platformFaultDomainCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformFaultDomainCount = mapped
    }

    /**
     * @param value Update Domain count.
     */
    @JvmName("itaqlwdygtyeppou")
    public suspend fun platformUpdateDomainCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.platformUpdateDomainCount = mapped
    }

    /**
     * @param value Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("haidvvffariqvqna")
    public suspend fun proximityPlacementGroup(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param argument Specifies information about the proximity placement group that the availability set should be assigned to. Minimum api-version: 2018-04-01.
     */
    @JvmName("kbonwonhhelkdjnp")
    public suspend fun proximityPlacementGroup(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.proximityPlacementGroup = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wdodkcslpkixfnga")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
     */
    @JvmName("mrruntwhcthxyrej")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Sku of the availability set, only name is required to be set. See AvailabilitySetSkuTypes for possible set of values. Use 'Aligned' for virtual machines with managed disks and 'Classic' for virtual machines with unmanaged disks. Default value is 'Classic'.
     */
    @JvmName("orqvjcwmxvvupeog")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("sttxvrfkqjdvwddg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("nxoqdwbarwrnpvlq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of references to all virtual machines in the availability set.
     */
    @JvmName("jhffmmjuiblbisur")
    public suspend fun virtualMachines(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    /**
     * @param argument A list of references to all virtual machines in the availability set.
     */
    @JvmName("xpqbuuaamahyfdjy")
    public suspend fun virtualMachines(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument A list of references to all virtual machines in the availability set.
     */
    @JvmName("lakeffmoctcwtqmf")
    public suspend fun virtualMachines(vararg argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param argument A list of references to all virtual machines in the availability set.
     */
    @JvmName("spyuuaanolhrgcdp")
    public suspend fun virtualMachines(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.virtualMachines = mapped
    }

    /**
     * @param values A list of references to all virtual machines in the availability set.
     */
    @JvmName("nouanxspgfbmpumh")
    public suspend fun virtualMachines(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.virtualMachines = mapped
    }

    internal fun build(): AvailabilitySetArgs = AvailabilitySetArgs(
        availabilitySetName = availabilitySetName,
        location = location,
        platformFaultDomainCount = platformFaultDomainCount,
        platformUpdateDomainCount = platformUpdateDomainCount,
        proximityPlacementGroup = proximityPlacementGroup,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
        virtualMachines = virtualMachines,
    )
}
