@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupInstanceViewResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupPropertiesResponseAdditionalCapabilities
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupInstanceViewResponse.Companion.toKotlin as dedicatedHostGroupInstanceViewResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DedicatedHostGroupPropertiesResponseAdditionalCapabilities.Companion.toKotlin as dedicatedHostGroupPropertiesResponseAdditionalCapabilitiesToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SubResourceReadOnlyResponse.Companion.toKotlin as subResourceReadOnlyResponseToKotlin

/**
 * Builder for [DedicatedHostGroup].
 */
@PulumiTagMarker
public class DedicatedHostGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHostGroupArgs = DedicatedHostGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHostGroupArgsBuilder.() -> Unit) {
        val builder = DedicatedHostGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DedicatedHostGroup {
        val builtJavaResource =
            com.pulumi.azurenative.compute.DedicatedHostGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DedicatedHostGroup(builtJavaResource)
    }
}

/**
 * Specifies information about the dedicated host group that the dedicated hosts should be assigned to. Currently, a dedicated host can only be added to a dedicated host group at creation time. An existing dedicated host cannot be added to another dedicated host group.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update a dedicated host group with Ultra SSD support.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHostGroup = new AzureNative.Compute.DedicatedHostGroup("dedicatedHostGroup", new()
 *     {
 *         AdditionalCapabilities = new AzureNative.Compute.Inputs.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs
 *         {
 *             UltraSSDEnabled = true,
 *         },
 *         HostGroupName = "myDedicatedHostGroup",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 3,
 *         ResourceGroupName = "myResourceGroup",
 *         SupportAutomaticPlacement = true,
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHostGroup(ctx, "dedicatedHostGroup", &compute.DedicatedHostGroupArgs{
 * 			AdditionalCapabilities: &compute.DedicatedHostGroupPropertiesAdditionalCapabilitiesArgs{
 * 				UltraSSDEnabled: pulumi.Bool(true),
 * 			},
 * 			HostGroupName:             pulumi.String("myDedicatedHostGroup"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(3),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			SupportAutomaticPlacement: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHostGroup;
 * import com.pulumi.azurenative.compute.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHostGroup = new DedicatedHostGroup("dedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .additionalCapabilities(Map.of("ultraSSDEnabled", true))
 *             .hostGroupName("myDedicatedHostGroup")
 *             .location("westus")
 *             .platformFaultDomainCount(3)
 *             .resourceGroupName("myResourceGroup")
 *             .supportAutomaticPlacement(true)
 *             .tags(Map.of("department", "finance"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a dedicated host group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHostGroup = new AzureNative.Compute.DedicatedHostGroup("dedicatedHostGroup", new()
 *     {
 *         HostGroupName = "myDedicatedHostGroup",
 *         Location = "westus",
 *         PlatformFaultDomainCount = 3,
 *         ResourceGroupName = "myResourceGroup",
 *         SupportAutomaticPlacement = true,
 *         Tags =
 *         {
 *             { "department", "finance" },
 *         },
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewDedicatedHostGroup(ctx, "dedicatedHostGroup", &compute.DedicatedHostGroupArgs{
 * 			HostGroupName:             pulumi.String("myDedicatedHostGroup"),
 * 			Location:                  pulumi.String("westus"),
 * 			PlatformFaultDomainCount:  pulumi.Int(3),
 * 			ResourceGroupName:         pulumi.String("myResourceGroup"),
 * 			SupportAutomaticPlacement: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"department": pulumi.String("finance"),
 * 			},
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.DedicatedHostGroup;
 * import com.pulumi.azurenative.compute.DedicatedHostGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHostGroup = new DedicatedHostGroup("dedicatedHostGroup", DedicatedHostGroupArgs.builder()
 *             .hostGroupName("myDedicatedHostGroup")
 *             .location("westus")
 *             .platformFaultDomainCount(3)
 *             .resourceGroupName("myResourceGroup")
 *             .supportAutomaticPlacement(true)
 *             .tags(Map.of("department", "finance"))
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:DedicatedHostGroup myDedicatedHostGroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/hostGroups/{hostGroupName}
 * ```
 */
public class DedicatedHostGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.DedicatedHostGroup,
) : KotlinCustomResource(javaResource, DedicatedHostGroupMapper) {
    /**
     * Enables or disables a capability on the dedicated host group. Minimum api-version: 2022-03-01.
     */
    public val additionalCapabilities:
        Output<DedicatedHostGroupPropertiesResponseAdditionalCapabilities>?
        get() = javaResource.additionalCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dedicatedHostGroupPropertiesResponseAdditionalCapabilitiesToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A list of references to all dedicated hosts in the dedicated host group.
     */
    public val hosts: Output<List<SubResourceReadOnlyResponse>>
        get() = javaResource.hosts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    subResourceReadOnlyResponseToKotlin(args0)
                })
            })
        })

    /**
     * The dedicated host group instance view, which has the list of instance view of the dedicated hosts under the dedicated host group.
     */
    public val instanceView: Output<DedicatedHostGroupInstanceViewResponse>
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.let({ args0 ->
                dedicatedHostGroupInstanceViewResponseToKotlin(args0)
            })
        })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Number of fault domains that the host group can span.
     */
    public val platformFaultDomainCount: Output<Int>
        get() = javaResource.platformFaultDomainCount().applyValue({ args0 -> args0 })

    /**
     * Specifies whether virtual machines or virtual machine scale sets can be placed automatically on the dedicated host group. Automatic placement means resources are allocated on dedicated hosts, that are chosen by Azure, under the dedicated host group. The value is defaulted to 'false' when not provided. Minimum api-version: 2020-06-01.
     */
    public val supportAutomaticPlacement: Output<Boolean>?
        get() = javaResource.supportAutomaticPlacement().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Availability Zone to use for this host group. Only single zone is supported. The zone can be assigned only during creation. If not provided, the group supports all zones in the region. If provided, enforces each host in the group to be in the same zone.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object DedicatedHostGroupMapper : ResourceMapper<DedicatedHostGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.DedicatedHostGroup::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHostGroup = DedicatedHostGroup(
        javaResource as
            com.pulumi.azurenative.compute.DedicatedHostGroup,
    )
}

/**
 * @see [DedicatedHostGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHostGroup].
 */
public suspend fun dedicatedHostGroup(
    name: String,
    block: suspend DedicatedHostGroupResourceBuilder.() -> Unit,
): DedicatedHostGroup {
    val builder = DedicatedHostGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHostGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHostGroup(name: String): DedicatedHostGroup {
    val builder = DedicatedHostGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
