@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.GalleryApplicationVersionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationVersionPublishingProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationVersionPublishingProfileArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationVersionSafetyProfileArgs
import com.pulumi.azurenative.compute.kotlin.inputs.GalleryApplicationVersionSafetyProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Specifies information about the gallery Application Version that you want to create or update.
 * Azure REST API version: 2022-03-03. Prior API version in Azure Native 1.x: 2020-09-30.
 * ## Example Usage
 * ### Create or update a simple gallery Application Version.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var galleryApplicationVersion = new AzureNative.Compute.GalleryApplicationVersion("galleryApplicationVersion", new()
 *     {
 *         GalleryApplicationName = "myGalleryApplicationName",
 *         GalleryApplicationVersionName = "1.0.0",
 *         GalleryName = "myGalleryName",
 *         Location = "West US",
 *         PublishingProfile = new AzureNative.Compute.Inputs.GalleryApplicationVersionPublishingProfileArgs
 *         {
 *             CustomActions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.GalleryApplicationCustomActionArgs
 *                 {
 *                     Description = "This is the custom action description.",
 *                     Name = "myCustomAction",
 *                     Parameters = new[]
 *                     {
 *                         new AzureNative.Compute.Inputs.GalleryApplicationCustomActionParameterArgs
 *                         {
 *                             DefaultValue = "default value of parameter.",
 *                             Description = "This is the description of the parameter",
 *                             Name = "myCustomActionParameter",
 *                             Required = false,
 *                             Type = AzureNative.Compute.GalleryApplicationCustomActionParameterType.String,
 *                         },
 *                     },
 *                     Script = "myCustomActionScript",
 *                 },
 *             },
 *             EndOfLifeDate = "2019-07-01T07:00:00Z",
 *             ManageActions = new AzureNative.Compute.Inputs.UserArtifactManageArgs
 *             {
 *                 Install = "powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\"",
 *                 Remove = "del C:\\package ",
 *             },
 *             ReplicaCount = 1,
 *             Source = new AzureNative.Compute.Inputs.UserArtifactSourceArgs
 *             {
 *                 MediaLink = "https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}",
 *             },
 *             StorageAccountType = "Standard_LRS",
 *             TargetRegions = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.TargetRegionArgs
 *                 {
 *                     ExcludeFromLatest = false,
 *                     Name = "West US",
 *                     RegionalReplicaCount = 1,
 *                     StorageAccountType = "Standard_LRS",
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         SafetyProfile = new AzureNative.Compute.Inputs.GalleryApplicationVersionSafetyProfileArgs
 *         {
 *             AllowDeletionOfReplicatedLocations = false,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := compute.NewGalleryApplicationVersion(ctx, "galleryApplicationVersion", &compute.GalleryApplicationVersionArgs{
 * GalleryApplicationName: pulumi.String("myGalleryApplicationName"),
 * GalleryApplicationVersionName: pulumi.String("1.0.0"),
 * GalleryName: pulumi.String("myGalleryName"),
 * Location: pulumi.String("West US"),
 * PublishingProfile: compute.GalleryApplicationVersionPublishingProfileResponse{
 * CustomActions: compute.GalleryApplicationCustomActionArray{
 * interface{}{
 * Description: pulumi.String("This is the custom action description."),
 * Name: pulumi.String("myCustomAction"),
 * Parameters: compute.GalleryApplicationCustomActionParameterArray{
 * &compute.GalleryApplicationCustomActionParameterArgs{
 * DefaultValue: pulumi.String("default value of parameter."),
 * Description: pulumi.String("This is the description of the parameter"),
 * Name: pulumi.String("myCustomActionParameter"),
 * Required: pulumi.Bool(false),
 * Type: compute.GalleryApplicationCustomActionParameterTypeString,
 * },
 * },
 * Script: pulumi.String("myCustomActionScript"),
 * },
 * },
 * EndOfLifeDate: pulumi.String("2019-07-01T07:00:00Z"),
 * ManageActions: &compute.UserArtifactManageArgs{
 * Install: pulumi.String("powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\""),
 * Remove: pulumi.String("del C:\\package "),
 * },
 * ReplicaCount: pulumi.Int(1),
 * Source: &compute.UserArtifactSourceArgs{
 * MediaLink: pulumi.String("https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}"),
 * },
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * TargetRegions: compute.TargetRegionArray{
 * &compute.TargetRegionArgs{
 * ExcludeFromLatest: pulumi.Bool(false),
 * Name: pulumi.String("West US"),
 * RegionalReplicaCount: pulumi.Int(1),
 * StorageAccountType: pulumi.String("Standard_LRS"),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SafetyProfile: &compute.GalleryApplicationVersionSafetyProfileArgs{
 * AllowDeletionOfReplicatedLocations: pulumi.Bool(false),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.GalleryApplicationVersion;
 * import com.pulumi.azurenative.compute.GalleryApplicationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var galleryApplicationVersion = new GalleryApplicationVersion("galleryApplicationVersion", GalleryApplicationVersionArgs.builder()
 *             .galleryApplicationName("myGalleryApplicationName")
 *             .galleryApplicationVersionName("1.0.0")
 *             .galleryName("myGalleryName")
 *             .location("West US")
 *             .publishingProfile(Map.ofEntries(
 *                 Map.entry("customActions", Map.ofEntries(
 *                     Map.entry("description", "This is the custom action description."),
 *                     Map.entry("name", "myCustomAction"),
 *                     Map.entry("parameters", Map.ofEntries(
 *                         Map.entry("defaultValue", "default value of parameter."),
 *                         Map.entry("description", "This is the description of the parameter"),
 *                         Map.entry("name", "myCustomActionParameter"),
 *                         Map.entry("required", false),
 *                         Map.entry("type", "String")
 *                     )),
 *                     Map.entry("script", "myCustomActionScript")
 *                 )),
 *                 Map.entry("endOfLifeDate", "2019-07-01T07:00:00Z"),
 *                 Map.entry("manageActions", Map.ofEntries(
 *                     Map.entry("install", "powershell -command \"Expand-Archive -Path package.zip -DestinationPath C:\\package\""),
 *                     Map.entry("remove", "del C:\\package ")
 *                 )),
 *                 Map.entry("replicaCount", 1),
 *                 Map.entry("source", Map.of("mediaLink", "https://mystorageaccount.blob.core.windows.net/mycontainer/package.zip?{sasKey}")),
 *                 Map.entry("storageAccountType", "Standard_LRS"),
 *                 Map.entry("targetRegions", Map.ofEntries(
 *                     Map.entry("excludeFromLatest", false),
 *                     Map.entry("name", "West US"),
 *                     Map.entry("regionalReplicaCount", 1),
 *                     Map.entry("storageAccountType", "Standard_LRS")
 *                 ))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .safetyProfile(Map.of("allowDeletionOfReplicatedLocations", false))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:GalleryApplicationVersion 1.0.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/applications/{galleryApplicationName}/versions/{galleryApplicationVersionName}
 * ```
 * @property galleryApplicationName The name of the gallery Application Definition in which the Application Version is to be created.
 * @property galleryApplicationVersionName The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
 * @property galleryName The name of the Shared Application Gallery in which the Application Definition resides.
 * @property location Resource location
 * @property publishingProfile The publishing profile of a gallery image version.
 * @property resourceGroupName The name of the resource group.
 * @property safetyProfile The safety profile of the Gallery Application Version.
 * @property tags Resource tags
 */
public data class GalleryApplicationVersionArgs(
    public val galleryApplicationName: Output<String>? = null,
    public val galleryApplicationVersionName: Output<String>? = null,
    public val galleryName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val publishingProfile: Output<GalleryApplicationVersionPublishingProfileArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val safetyProfile: Output<GalleryApplicationVersionSafetyProfileArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.GalleryApplicationVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.GalleryApplicationVersionArgs =
        com.pulumi.azurenative.compute.GalleryApplicationVersionArgs.builder()
            .galleryApplicationName(galleryApplicationName?.applyValue({ args0 -> args0 }))
            .galleryApplicationVersionName(galleryApplicationVersionName?.applyValue({ args0 -> args0 }))
            .galleryName(galleryName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .publishingProfile(publishingProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .safetyProfile(safetyProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GalleryApplicationVersionArgs].
 */
@PulumiTagMarker
public class GalleryApplicationVersionArgsBuilder internal constructor() {
    private var galleryApplicationName: Output<String>? = null

    private var galleryApplicationVersionName: Output<String>? = null

    private var galleryName: Output<String>? = null

    private var location: Output<String>? = null

    private var publishingProfile: Output<GalleryApplicationVersionPublishingProfileArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var safetyProfile: Output<GalleryApplicationVersionSafetyProfileArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the gallery Application Definition in which the Application Version is to be created.
     */
    @JvmName("vfjcxhncndubnjsv")
    public suspend fun galleryApplicationName(`value`: Output<String>) {
        this.galleryApplicationName = value
    }

    /**
     * @param value The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
     */
    @JvmName("cndqgtdybxyewtem")
    public suspend fun galleryApplicationVersionName(`value`: Output<String>) {
        this.galleryApplicationVersionName = value
    }

    /**
     * @param value The name of the Shared Application Gallery in which the Application Definition resides.
     */
    @JvmName("vqqjrmehoboaeldq")
    public suspend fun galleryName(`value`: Output<String>) {
        this.galleryName = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("rfigekfqhuoywwja")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The publishing profile of a gallery image version.
     */
    @JvmName("vdderimktjwwtyue")
    public suspend
    fun publishingProfile(`value`: Output<GalleryApplicationVersionPublishingProfileArgs>) {
        this.publishingProfile = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sthxkteeexfqafmc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The safety profile of the Gallery Application Version.
     */
    @JvmName("slnyjojslrkupemk")
    public suspend fun safetyProfile(`value`: Output<GalleryApplicationVersionSafetyProfileArgs>) {
        this.safetyProfile = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("apedminqedtivpyn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the gallery Application Definition in which the Application Version is to be created.
     */
    @JvmName("vlkqbepfmwcxqabf")
    public suspend fun galleryApplicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryApplicationName = mapped
    }

    /**
     * @param value The name of the gallery Application Version to be created. Needs to follow semantic version name pattern: The allowed characters are digit and period. Digits must be within the range of a 32-bit integer. Format: <MajorVersion>.<MinorVersion>.<Patch>
     */
    @JvmName("kspunwoljcpcwxnf")
    public suspend fun galleryApplicationVersionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryApplicationVersionName = mapped
    }

    /**
     * @param value The name of the Shared Application Gallery in which the Application Definition resides.
     */
    @JvmName("jetirlqrytkvajxn")
    public suspend fun galleryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryName = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("nvpqjvahylrevxsu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The publishing profile of a gallery image version.
     */
    @JvmName("gjxyuhuyrclwveoq")
    public suspend fun publishingProfile(`value`: GalleryApplicationVersionPublishingProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publishingProfile = mapped
    }

    /**
     * @param argument The publishing profile of a gallery image version.
     */
    @JvmName("gpjyndsgpgtvvamc")
    public suspend
    fun publishingProfile(argument: suspend GalleryApplicationVersionPublishingProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryApplicationVersionPublishingProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.publishingProfile = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qksaesroycaoimwi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The safety profile of the Gallery Application Version.
     */
    @JvmName("ptiedrbffvdwuflh")
    public suspend fun safetyProfile(`value`: GalleryApplicationVersionSafetyProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.safetyProfile = mapped
    }

    /**
     * @param argument The safety profile of the Gallery Application Version.
     */
    @JvmName("axetwkphjymhmrol")
    public suspend
    fun safetyProfile(argument: suspend GalleryApplicationVersionSafetyProfileArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryApplicationVersionSafetyProfileArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.safetyProfile = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("jtqyvcmerymrtcpu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("hixxwiyfyjkdinpq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GalleryApplicationVersionArgs = GalleryApplicationVersionArgs(
        galleryApplicationName = galleryApplicationName,
        galleryApplicationVersionName = galleryApplicationVersionName,
        galleryName = galleryName,
        location = location,
        publishingProfile = publishingProfile,
        resourceGroupName = resourceGroupName,
        safetyProfile = safetyProfile,
        tags = tags,
    )
}
