@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.CopyCompletionErrorResponse
import com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SnapshotSkuResponse
import com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.CopyCompletionErrorResponse.Companion.toKotlin as copyCompletionErrorResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.CreationDataResponse.Companion.toKotlin as creationDataResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.DiskSecurityProfileResponse.Companion.toKotlin as diskSecurityProfileResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionResponse.Companion.toKotlin as encryptionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.EncryptionSettingsCollectionResponse.Companion.toKotlin as encryptionSettingsCollectionResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.PurchasePlanResponse.Companion.toKotlin as purchasePlanResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SnapshotSkuResponse.Companion.toKotlin as snapshotSkuResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.SupportedCapabilitiesResponse.Companion.toKotlin as supportedCapabilitiesResponseToKotlin

/**
 * Builder for [Snapshot].
 */
@PulumiTagMarker
public class SnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SnapshotArgs = SnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SnapshotArgsBuilder.() -> Unit) {
        val builder = SnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Snapshot {
        val builtJavaResource = com.pulumi.azurenative.compute.Snapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Snapshot(builtJavaResource)
    }
}

/**
 * Snapshot resource.
 * Azure REST API version: 2022-07-02. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2016-04-30-preview, 2017-03-30, 2018-06-01, 2023-01-02, 2023-04-02.
 * ## Example Usage
 * ### Create a snapshot by importing an unmanaged blob from a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *             StorageAccountId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Import"),
 * 				SourceUri:        pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 				StorageAccountId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 *                 Map.entry("storageAccountId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Storage/storageAccounts/myStorageAccount")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot by importing an unmanaged blob from the same subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Import",
 *             SourceUri = "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption: pulumi.String("Import"),
 * 				SourceUri:    pulumi.String("https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Import"),
 *                 Map.entry("sourceUri", "https://mystorageaccount.blob.core.windows.net/osimages/osimage.vhd")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot from an existing snapshot in the same or a different subscription in a different region.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "CopyStart",
 *             SourceResourceId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("CopyStart"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "CopyStart"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a snapshot from an existing snapshot in the same or a different subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var snapshot = new AzureNative.Compute.Snapshot("snapshot", new()
 *     {
 *         CreationData = new AzureNative.Compute.Inputs.CreationDataArgs
 *         {
 *             CreateOption = "Copy",
 *             SourceResourceId = "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "myResourceGroup",
 *         SnapshotName = "mySnapshot2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSnapshot(ctx, "snapshot", &compute.SnapshotArgs{
 * 			CreationData: &compute.CreationDataArgs{
 * 				CreateOption:     pulumi.String("Copy"),
 * 				SourceResourceId: pulumi.String("subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1"),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SnapshotName:      pulumi.String("mySnapshot2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.Snapshot;
 * import com.pulumi.azurenative.compute.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var snapshot = new Snapshot("snapshot", SnapshotArgs.builder()
 *             .creationData(Map.ofEntries(
 *                 Map.entry("createOption", "Copy"),
 *                 Map.entry("sourceResourceId", "subscriptions/{subscription-id}/resourceGroups/myResourceGroup/providers/Microsoft.Compute/snapshots/mySnapshot1")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("myResourceGroup")
 *             .snapshotName("mySnapshot2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:Snapshot mySnapshot2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/snapshots/{snapshotName}
 * ```
 */
public class Snapshot internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.Snapshot,
) : KotlinCustomResource(javaResource, SnapshotMapper) {
    /**
     * Percentage complete for the background copy when a resource is created via the CopyStart operation.
     */
    public val completionPercent: Output<Double>?
        get() = javaResource.completionPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates the error details if the background copy of a resource created via the CopyStart operation fails.
     */
    public val copyCompletionError: Output<CopyCompletionErrorResponse>?
        get() = javaResource.copyCompletionError().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> copyCompletionErrorResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Disk source information. CreationData information cannot be changed after the disk has been created.
     */
    public val creationData: Output<CreationDataResponse>
        get() = javaResource.creationData().applyValue({ args0 ->
            args0.let({ args0 ->
                creationDataResponseToKotlin(args0)
            })
        })

    /**
     * Additional authentication requirements when exporting or uploading to a disk or snapshot.
     */
    public val dataAccessAuthMode: Output<String>?
        get() = javaResource.dataAccessAuthMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM id of the DiskAccess resource for using private endpoints on disks.
     */
    public val diskAccessId: Output<String>?
        get() = javaResource.diskAccessId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The size of the disk in bytes. This field is read only.
     */
    public val diskSizeBytes: Output<Double>
        get() = javaResource.diskSizeBytes().applyValue({ args0 -> args0 })

    /**
     * If creationData.createOption is Empty, this field is mandatory and it indicates the size of the disk to create. If this field is present for updates or creation with other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a running VM, and can only increase the disk's size.
     */
    public val diskSizeGB: Output<Int>?
        get() = javaResource.diskSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The state of the snapshot.
     */
    public val diskState: Output<String>
        get() = javaResource.diskState().applyValue({ args0 -> args0 })

    /**
     * Encryption property can be used to encrypt data at rest with customer managed keys or platform managed keys.
     */
    public val encryption: Output<EncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Encryption settings collection used be Azure Disk Encryption, can contain multiple encryption settings per disk or snapshot.
     */
    public val encryptionSettingsCollection: Output<EncryptionSettingsCollectionResponse>?
        get() = javaResource.encryptionSettingsCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> encryptionSettingsCollectionResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The extended location where the snapshot will be created. Extended location cannot be changed.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hypervisor generation of the Virtual Machine. Applicable to OS disks only.
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether a snapshot is incremental. Incremental snapshots on the same disk occupy less space than full snapshots and can be diffed.
     */
    public val incremental: Output<Boolean>?
        get() = javaResource.incremental().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Incremental snapshots for a disk share an incremental snapshot family id. The Get Page Range Diff API can only be called on incremental snapshots with the same family id.
     */
    public val incrementalSnapshotFamilyId: Output<String>
        get() = javaResource.incrementalSnapshotFamilyId().applyValue({ args0 -> args0 })

    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Unused. Always Null.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Policy for accessing the disk via network.
     */
    public val networkAccessPolicy: Output<String>?
        get() = javaResource.networkAccessPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Operating System type.
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The disk provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Policy for controlling export on the disk.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Purchase plan information for the image from which the source disk for the snapshot was originally created.
     */
    public val purchasePlan: Output<PurchasePlanResponse>?
        get() = javaResource.purchasePlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    purchasePlanResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Contains the security related information for the resource.
     */
    public val securityProfile: Output<DiskSecurityProfileResponse>?
        get() = javaResource.securityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> diskSecurityProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS. This is an optional parameter for incremental snapshot and the default behavior is the SKU will be set to the same sku as the previous snapshot
     */
    public val sku: Output<SnapshotSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    snapshotSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * List of supported capabilities for the image from which the source disk from the snapshot was originally created.
     */
    public val supportedCapabilities: Output<SupportedCapabilitiesResponse>?
        get() = javaResource.supportedCapabilities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> supportedCapabilitiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Indicates the OS on a snapshot supports hibernation.
     */
    public val supportsHibernation: Output<Boolean>?
        get() = javaResource.supportsHibernation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The time when the snapshot was created.
     */
    public val timeCreated: Output<String>
        get() = javaResource.timeCreated().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Unique Guid identifying the resource.
     */
    public val uniqueId: Output<String>
        get() = javaResource.uniqueId().applyValue({ args0 -> args0 })
}

public object SnapshotMapper : ResourceMapper<Snapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.Snapshot::class == javaResource::class

    override fun map(javaResource: Resource): Snapshot = Snapshot(
        javaResource as
            com.pulumi.azurenative.compute.Snapshot,
    )
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Snapshot].
 */
public suspend fun snapshot(name: String, block: suspend SnapshotResourceBuilder.() -> Unit):
    Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Snapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun snapshot(name: String): Snapshot {
    val builder = SnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
