@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SshPublicKey].
 */
@PulumiTagMarker
public class SshPublicKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SshPublicKeyArgs = SshPublicKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val builder = SshPublicKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SshPublicKey {
        val builtJavaResource = com.pulumi.azurenative.compute.SshPublicKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SshPublicKey(builtJavaResource)
    }
}

/**
 * Specifies information about the SSH public key.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2020-12-01.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create a new SSH public key resource.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sshPublicKey = new AzureNative.Compute.SshPublicKey("sshPublicKey", new()
 *     {
 *         Location = "westus",
 *         PublicKey = "{ssh-rsa public key}",
 *         ResourceGroupName = "myResourceGroup",
 *         SshPublicKeyName = "mySshPublicKeyName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewSshPublicKey(ctx, "sshPublicKey", &compute.SshPublicKeyArgs{
 * 			Location:          pulumi.String("westus"),
 * 			PublicKey:         pulumi.String("{ssh-rsa public key}"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			SshPublicKeyName:  pulumi.String("mySshPublicKeyName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.SshPublicKey;
 * import com.pulumi.azurenative.compute.SshPublicKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sshPublicKey = new SshPublicKey("sshPublicKey", SshPublicKeyArgs.builder()
 *             .location("westus")
 *             .publicKey("{ssh-rsa public key}")
 *             .resourceGroupName("myResourceGroup")
 *             .sshPublicKeyName("mySshPublicKeyName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:SshPublicKey mySshPublicKeyName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/sshPublicKeys/{sshPublicKeyName}
 * ```
 */
public class SshPublicKey internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.SshPublicKey,
) : KotlinCustomResource(javaResource, SshPublicKeyMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * SSH public key used to authenticate to a virtual machine through ssh. If this property is not initially provided when the resource is created, the publicKey property will be populated when generateKeyPair is called. If the public key is provided upon resource creation, the provided public key needs to be at least 2048-bit and in ssh-rsa format.
     */
    public val publicKey: Output<String>?
        get() = javaResource.publicKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SshPublicKeyMapper : ResourceMapper<SshPublicKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.SshPublicKey::class == javaResource::class

    override fun map(javaResource: Resource): SshPublicKey = SshPublicKey(
        javaResource as
            com.pulumi.azurenative.compute.SshPublicKey,
    )
}

/**
 * @see [SshPublicKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SshPublicKey].
 */
public suspend fun sshPublicKey(
    name: String,
    block: suspend SshPublicKeyResourceBuilder.() -> Unit,
): SshPublicKey {
    val builder = SshPublicKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SshPublicKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sshPublicKey(name: String): SshPublicKey {
    val builder = SshPublicKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
