@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.compute.kotlin.outputs.KeyVaultSecretReferenceResponse.Companion.toKotlin as keyVaultSecretReferenceResponseToKotlin
import com.pulumi.azurenative.compute.kotlin.outputs.VirtualMachineExtensionInstanceViewResponse.Companion.toKotlin as virtualMachineExtensionInstanceViewResponseToKotlin

/**
 * Builder for [VirtualMachineExtension].
 */
@PulumiTagMarker
public class VirtualMachineExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualMachineExtensionArgs = VirtualMachineExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualMachineExtensionArgsBuilder.() -> Unit) {
        val builder = VirtualMachineExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualMachineExtension {
        val builtJavaResource =
            com.pulumi.azurenative.compute.VirtualMachineExtension(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualMachineExtension(builtJavaResource)
    }
}

/**
 * Describes a Virtual Machine Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2023-07-01.
 * ## Example Usage
 * ### VirtualMachineExtension_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineExtension = new AzureNative.Compute.VirtualMachineExtension("virtualMachineExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         EnableAutomaticUpgrade = true,
 *         ForceUpdateTag = "a",
 *         InstanceView = new AzureNative.Compute.Inputs.VirtualMachineExtensionInstanceViewArgs
 *         {
 *             Name = "aaaaaaaaaaaaaaaaa",
 *             Statuses = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.InstanceViewStatusArgs
 *                 {
 *                     Code = "aaaaaaaaaaaaaaaaaaaaaaa",
 *                     DisplayStatus = "aaaaaa",
 *                     Level = AzureNative.Compute.StatusLevelTypes.Info,
 *                     Message = "a",
 *                     Time = "2021-11-30T12:58:26.522Z",
 *                 },
 *             },
 *             Substatuses = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.InstanceViewStatusArgs
 *                 {
 *                     Code = "aaaaaaaaaaaaaaaaaaaaaaa",
 *                     DisplayStatus = "aaaaaa",
 *                     Level = AzureNative.Compute.StatusLevelTypes.Info,
 *                     Message = "a",
 *                     Time = "2021-11-30T12:58:26.522Z",
 *                 },
 *             },
 *             Type = "aaaaaaaaa",
 *             TypeHandlerVersion = "aaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         },
 *         Location = "westus",
 *         ProtectedSettings = null,
 *         Publisher = "extPublisher",
 *         ResourceGroupName = "rgcompute",
 *         Settings = null,
 *         SuppressFailures = true,
 *         Tags =
 *         {
 *             { "key9183", "aa" },
 *         },
 *         Type = "extType",
 *         TypeHandlerVersion = "1.2",
 *         VmExtensionName = "aaaaaaaaaaaaa",
 *         VmName = "aaaaaaaaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineExtension(ctx, "virtualMachineExtension", &compute.VirtualMachineExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 			ForceUpdateTag:          pulumi.String("a"),
 * 			InstanceView: compute.VirtualMachineExtensionInstanceViewResponse{
 * 				Name: pulumi.String("aaaaaaaaaaaaaaaaa"),
 * 				Statuses: compute.InstanceViewStatusArray{
 * 					&compute.InstanceViewStatusArgs{
 * 						Code:          pulumi.String("aaaaaaaaaaaaaaaaaaaaaaa"),
 * 						DisplayStatus: pulumi.String("aaaaaa"),
 * 						Level:         compute.StatusLevelTypesInfo,
 * 						Message:       pulumi.String("a"),
 * 						Time:          pulumi.String("2021-11-30T12:58:26.522Z"),
 * 					},
 * 				},
 * 				Substatuses: compute.InstanceViewStatusArray{
 * 					&compute.InstanceViewStatusArgs{
 * 						Code:          pulumi.String("aaaaaaaaaaaaaaaaaaaaaaa"),
 * 						DisplayStatus: pulumi.String("aaaaaa"),
 * 						Level:         compute.StatusLevelTypesInfo,
 * 						Message:       pulumi.String("a"),
 * 						Time:          pulumi.String("2021-11-30T12:58:26.522Z"),
 * 					},
 * 				},
 * 				Type:               pulumi.String("aaaaaaaaa"),
 * 				TypeHandlerVersion: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ProtectedSettings: nil,
 * 			Publisher:         pulumi.String("extPublisher"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			Settings:          nil,
 * 			SuppressFailures:  pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"key9183": pulumi.String("aa"),
 * 			},
 * 			Type:               pulumi.String("extType"),
 * 			TypeHandlerVersion: pulumi.String("1.2"),
 * 			VmExtensionName:    pulumi.String("aaaaaaaaaaaaa"),
 * 			VmName:             pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineExtension = new VirtualMachineExtension("virtualMachineExtension", VirtualMachineExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .enableAutomaticUpgrade(true)
 *             .forceUpdateTag("a")
 *             .instanceView(Map.ofEntries(
 *                 Map.entry("name", "aaaaaaaaaaaaaaaaa"),
 *                 Map.entry("statuses", Map.ofEntries(
 *                     Map.entry("code", "aaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("displayStatus", "aaaaaa"),
 *                     Map.entry("level", "Info"),
 *                     Map.entry("message", "a"),
 *                     Map.entry("time", "2021-11-30T12:58:26.522Z")
 *                 )),
 *                 Map.entry("substatuses", Map.ofEntries(
 *                     Map.entry("code", "aaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("displayStatus", "aaaaaa"),
 *                     Map.entry("level", "Info"),
 *                     Map.entry("message", "a"),
 *                     Map.entry("time", "2021-11-30T12:58:26.522Z")
 *                 )),
 *                 Map.entry("type", "aaaaaaaaa"),
 *                 Map.entry("typeHandlerVersion", "aaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             ))
 *             .location("westus")
 *             .protectedSettings()
 *             .publisher("extPublisher")
 *             .resourceGroupName("rgcompute")
 *             .settings()
 *             .suppressFailures(true)
 *             .tags(Map.of("key9183", "aa"))
 *             .type("extType")
 *             .typeHandlerVersion("1.2")
 *             .vmExtensionName("aaaaaaaaaaaaa")
 *             .vmName("aaaaaaaaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineExtension_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineExtension = new AzureNative.Compute.VirtualMachineExtension("virtualMachineExtension", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rgcompute",
 *         VmExtensionName = "myVMExtension",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineExtension(ctx, "virtualMachineExtension", &compute.VirtualMachineExtensionArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmExtensionName:   pulumi.String("myVMExtension"),
 * 			VmName:            pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineExtension = new VirtualMachineExtension("virtualMachineExtension", VirtualMachineExtensionArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rgcompute")
 *             .vmExtensionName("myVMExtension")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineExtension myVMExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}
 * ```
 */
public class VirtualMachineExtension internal constructor(
    override val javaResource: com.pulumi.azurenative.compute.VirtualMachineExtension,
) : KotlinCustomResource(javaResource, VirtualMachineExtensionMapper) {
    /**
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    public val enableAutomaticUpgrade: Output<Boolean>?
        get() = javaResource.enableAutomaticUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The virtual machine extension instance view.
     */
    public val instanceView: Output<VirtualMachineExtensionInstanceViewResponse>?
        get() = javaResource.instanceView().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualMachineExtensionInstanceViewResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    public val protectedSettings: Output<Any>?
        get() = javaResource.protectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extensions protected settings that are passed by reference, and consumed from key vault
     */
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceResponse>?
        get() = javaResource.protectedSettingsFromKeyVault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> keyVaultSecretReferenceResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Collection of extension names after which this extension needs to be provisioned.
     */
    public val provisionAfterExtensions: Output<List<String>>?
        get() = javaResource.provisionAfterExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the extension handler publisher.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Json formatted public settings for the extension.
     */
    public val settings: Output<Any>?
        get() = javaResource.settings().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    public val suppressFailures: Output<Boolean>?
        get() = javaResource.suppressFailures().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the script handler.
     */
    public val typeHandlerVersion: Output<String>?
        get() = javaResource.typeHandlerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualMachineExtensionMapper : ResourceMapper<VirtualMachineExtension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.compute.VirtualMachineExtension::class == javaResource::class

    override fun map(javaResource: Resource): VirtualMachineExtension =
        VirtualMachineExtension(
            javaResource as
                com.pulumi.azurenative.compute.VirtualMachineExtension,
        )
}

/**
 * @see [VirtualMachineExtension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualMachineExtension].
 */
public suspend fun virtualMachineExtension(
    name: String,
    block: suspend VirtualMachineExtensionResourceBuilder.() -> Unit,
): VirtualMachineExtension {
    val builder = VirtualMachineExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualMachineExtension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualMachineExtension(name: String): VirtualMachineExtension {
    val builder = VirtualMachineExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
