@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin

import com.pulumi.azurenative.compute.VirtualMachineExtensionArgs.builder
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgs
import com.pulumi.azurenative.compute.kotlin.inputs.KeyVaultSecretReferenceArgsBuilder
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineExtensionInstanceViewArgs
import com.pulumi.azurenative.compute.kotlin.inputs.VirtualMachineExtensionInstanceViewArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a Virtual Machine Extension.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2021-11-01, 2023-07-01.
 * ## Example Usage
 * ### VirtualMachineExtension_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineExtension = new AzureNative.Compute.VirtualMachineExtension("virtualMachineExtension", new()
 *     {
 *         AutoUpgradeMinorVersion = true,
 *         EnableAutomaticUpgrade = true,
 *         ForceUpdateTag = "a",
 *         InstanceView = new AzureNative.Compute.Inputs.VirtualMachineExtensionInstanceViewArgs
 *         {
 *             Name = "aaaaaaaaaaaaaaaaa",
 *             Statuses = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.InstanceViewStatusArgs
 *                 {
 *                     Code = "aaaaaaaaaaaaaaaaaaaaaaa",
 *                     DisplayStatus = "aaaaaa",
 *                     Level = AzureNative.Compute.StatusLevelTypes.Info,
 *                     Message = "a",
 *                     Time = "2021-11-30T12:58:26.522Z",
 *                 },
 *             },
 *             Substatuses = new[]
 *             {
 *                 new AzureNative.Compute.Inputs.InstanceViewStatusArgs
 *                 {
 *                     Code = "aaaaaaaaaaaaaaaaaaaaaaa",
 *                     DisplayStatus = "aaaaaa",
 *                     Level = AzureNative.Compute.StatusLevelTypes.Info,
 *                     Message = "a",
 *                     Time = "2021-11-30T12:58:26.522Z",
 *                 },
 *             },
 *             Type = "aaaaaaaaa",
 *             TypeHandlerVersion = "aaaaaaaaaaaaaaaaaaaaaaaaaa",
 *         },
 *         Location = "westus",
 *         ProtectedSettings = null,
 *         Publisher = "extPublisher",
 *         ResourceGroupName = "rgcompute",
 *         Settings = null,
 *         SuppressFailures = true,
 *         Tags =
 *         {
 *             { "key9183", "aa" },
 *         },
 *         Type = "extType",
 *         TypeHandlerVersion = "1.2",
 *         VmExtensionName = "aaaaaaaaaaaaa",
 *         VmName = "aaaaaaaaaaaaaaaaaaaaaaaa",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineExtension(ctx, "virtualMachineExtension", &compute.VirtualMachineExtensionArgs{
 * 			AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 			EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 			ForceUpdateTag:          pulumi.String("a"),
 * 			InstanceView: compute.VirtualMachineExtensionInstanceViewResponse{
 * 				Name: pulumi.String("aaaaaaaaaaaaaaaaa"),
 * 				Statuses: compute.InstanceViewStatusArray{
 * 					&compute.InstanceViewStatusArgs{
 * 						Code:          pulumi.String("aaaaaaaaaaaaaaaaaaaaaaa"),
 * 						DisplayStatus: pulumi.String("aaaaaa"),
 * 						Level:         compute.StatusLevelTypesInfo,
 * 						Message:       pulumi.String("a"),
 * 						Time:          pulumi.String("2021-11-30T12:58:26.522Z"),
 * 					},
 * 				},
 * 				Substatuses: compute.InstanceViewStatusArray{
 * 					&compute.InstanceViewStatusArgs{
 * 						Code:          pulumi.String("aaaaaaaaaaaaaaaaaaaaaaa"),
 * 						DisplayStatus: pulumi.String("aaaaaa"),
 * 						Level:         compute.StatusLevelTypesInfo,
 * 						Message:       pulumi.String("a"),
 * 						Time:          pulumi.String("2021-11-30T12:58:26.522Z"),
 * 					},
 * 				},
 * 				Type:               pulumi.String("aaaaaaaaa"),
 * 				TypeHandlerVersion: pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ProtectedSettings: nil,
 * 			Publisher:         pulumi.String("extPublisher"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			Settings:          nil,
 * 			SuppressFailures:  pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"key9183": pulumi.String("aa"),
 * 			},
 * 			Type:               pulumi.String("extType"),
 * 			TypeHandlerVersion: pulumi.String("1.2"),
 * 			VmExtensionName:    pulumi.String("aaaaaaaaaaaaa"),
 * 			VmName:             pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaa"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineExtension = new VirtualMachineExtension("virtualMachineExtension", VirtualMachineExtensionArgs.builder()
 *             .autoUpgradeMinorVersion(true)
 *             .enableAutomaticUpgrade(true)
 *             .forceUpdateTag("a")
 *             .instanceView(Map.ofEntries(
 *                 Map.entry("name", "aaaaaaaaaaaaaaaaa"),
 *                 Map.entry("statuses", Map.ofEntries(
 *                     Map.entry("code", "aaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("displayStatus", "aaaaaa"),
 *                     Map.entry("level", "Info"),
 *                     Map.entry("message", "a"),
 *                     Map.entry("time", "2021-11-30T12:58:26.522Z")
 *                 )),
 *                 Map.entry("substatuses", Map.ofEntries(
 *                     Map.entry("code", "aaaaaaaaaaaaaaaaaaaaaaa"),
 *                     Map.entry("displayStatus", "aaaaaa"),
 *                     Map.entry("level", "Info"),
 *                     Map.entry("message", "a"),
 *                     Map.entry("time", "2021-11-30T12:58:26.522Z")
 *                 )),
 *                 Map.entry("type", "aaaaaaaaa"),
 *                 Map.entry("typeHandlerVersion", "aaaaaaaaaaaaaaaaaaaaaaaaaa")
 *             ))
 *             .location("westus")
 *             .protectedSettings()
 *             .publisher("extPublisher")
 *             .resourceGroupName("rgcompute")
 *             .settings()
 *             .suppressFailures(true)
 *             .tags(Map.of("key9183", "aa"))
 *             .type("extType")
 *             .typeHandlerVersion("1.2")
 *             .vmExtensionName("aaaaaaaaaaaaa")
 *             .vmName("aaaaaaaaaaaaaaaaaaaaaaaa")
 *             .build());
 *     }
 * }
 * ```
 * ### VirtualMachineExtension_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualMachineExtension = new AzureNative.Compute.VirtualMachineExtension("virtualMachineExtension", new()
 *     {
 *         Location = "westus",
 *         ResourceGroupName = "rgcompute",
 *         VmExtensionName = "myVMExtension",
 *         VmName = "myVM",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/compute/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := compute.NewVirtualMachineExtension(ctx, "virtualMachineExtension", &compute.VirtualMachineExtensionArgs{
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("rgcompute"),
 * 			VmExtensionName:   pulumi.String("myVMExtension"),
 * 			VmName:            pulumi.String("myVM"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.compute.VirtualMachineExtension;
 * import com.pulumi.azurenative.compute.VirtualMachineExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualMachineExtension = new VirtualMachineExtension("virtualMachineExtension", VirtualMachineExtensionArgs.builder()
 *             .location("westus")
 *             .resourceGroupName("rgcompute")
 *             .vmExtensionName("myVMExtension")
 *             .vmName("myVM")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:compute:VirtualMachineExtension myVMExtension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/extensions/{vmExtensionName}
 * ```
 * @property autoUpgradeMinorVersion Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
 * @property enableAutomaticUpgrade Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
 * @property forceUpdateTag How the extension handler should be forced to update even if the extension configuration has not changed.
 * @property instanceView The virtual machine extension instance view.
 * @property location Resource location
 * @property protectedSettings The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
 * @property protectedSettingsFromKeyVault The extensions protected settings that are passed by reference, and consumed from key vault
 * @property provisionAfterExtensions Collection of extension names after which this extension needs to be provisioned.
 * @property publisher The name of the extension handler publisher.
 * @property resourceGroupName The name of the resource group.
 * @property settings Json formatted public settings for the extension.
 * @property suppressFailures Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
 * @property tags Resource tags
 * @property type Specifies the type of the extension; an example is "CustomScriptExtension".
 * @property typeHandlerVersion Specifies the version of the script handler.
 * @property vmExtensionName The name of the virtual machine extension.
 * @property vmName The name of the virtual machine where the extension should be created or updated.
 */
public data class VirtualMachineExtensionArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val enableAutomaticUpgrade: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null,
    public val location: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null,
    public val provisionAfterExtensions: Output<List<String>>? = null,
    public val publisher: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val settings: Output<Any>? = null,
    public val suppressFailures: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
    public val vmExtensionName: Output<String>? = null,
    public val vmName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.VirtualMachineExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.VirtualMachineExtensionArgs =
        com.pulumi.azurenative.compute.VirtualMachineExtensionArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .enableAutomaticUpgrade(enableAutomaticUpgrade?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .instanceView(instanceView?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisionAfterExtensions(
                provisionAfterExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .suppressFailures(suppressFailures?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 }))
            .vmExtensionName(vmExtensionName?.applyValue({ args0 -> args0 }))
            .vmName(vmName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineExtensionArgs].
 */
@PulumiTagMarker
public class VirtualMachineExtensionArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var enableAutomaticUpgrade: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var instanceView: Output<VirtualMachineExtensionInstanceViewArgs>? = null

    private var location: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<KeyVaultSecretReferenceArgs>? = null

    private var provisionAfterExtensions: Output<List<String>>? = null

    private var publisher: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var settings: Output<Any>? = null

    private var suppressFailures: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    private var vmExtensionName: Output<String>? = null

    private var vmName: Output<String>? = null

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("ibeylnqbcmvclcyq")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("jubagmfvwxbsxslk")
    public suspend fun enableAutomaticUpgrade(`value`: Output<Boolean>) {
        this.enableAutomaticUpgrade = value
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("bgcfmjguggnawoed")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("lljwdqqrhsfuyblm")
    public suspend fun instanceView(`value`: Output<VirtualMachineExtensionInstanceViewArgs>) {
        this.instanceView = value
    }

    /**
     * @param value Resource location
     */
    @JvmName("huvwlnujdjtcfmpu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("jrmpqcuuremfntbd")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("oevpdngkgejctivv")
    public suspend fun protectedSettingsFromKeyVault(`value`: Output<KeyVaultSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("fsqohpgrmasxkabh")
    public suspend fun provisionAfterExtensions(`value`: Output<List<String>>) {
        this.provisionAfterExtensions = value
    }

    @JvmName("etreriiujxxdnesu")
    public suspend fun provisionAfterExtensions(vararg values: Output<String>) {
        this.provisionAfterExtensions = Output.all(values.asList())
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("dexqlkfnpjswlbth")
    public suspend fun provisionAfterExtensions(values: List<Output<String>>) {
        this.provisionAfterExtensions = Output.all(values)
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("qvcdcutfddccobae")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pbgguawwwthyuxkt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("ewixelvsscuaijos")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("jwgilvgrskbxkfgo")
    public suspend fun suppressFailures(`value`: Output<Boolean>) {
        this.suppressFailures = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("vweytekifmfegpfl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("joipslywoqgsllri")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("djojrutxfflrnsdg")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("tvhuvhgmionmjsjt")
    public suspend fun vmExtensionName(`value`: Output<String>) {
        this.vmExtensionName = value
    }

    /**
     * @param value The name of the virtual machine where the extension should be created or updated.
     */
    @JvmName("spyhxubemrumejsm")
    public suspend fun vmName(`value`: Output<String>) {
        this.vmName = value
    }

    /**
     * @param value Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    @JvmName("rphviddburqcsqya")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Indicates whether the extension should be automatically upgraded by the platform if there is a newer version of the extension available.
     */
    @JvmName("hasevgigafcoikxr")
    public suspend fun enableAutomaticUpgrade(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAutomaticUpgrade = mapped
    }

    /**
     * @param value How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    @JvmName("uwgcwrcxtatnsjnn")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value The virtual machine extension instance view.
     */
    @JvmName("dwxfedpnqtejdghf")
    public suspend fun instanceView(`value`: VirtualMachineExtensionInstanceViewArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceView = mapped
    }

    /**
     * @param argument The virtual machine extension instance view.
     */
    @JvmName("athhhstushobktwi")
    public suspend
    fun instanceView(argument: suspend VirtualMachineExtensionInstanceViewArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineExtensionInstanceViewArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceView = mapped
    }

    /**
     * @param value Resource location
     */
    @JvmName("enosmifbmwscpeaf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The extension can contain either protectedSettings or protectedSettingsFromKeyVault or no protected settings at all.
     */
    @JvmName("thvtsxyboffvpgdo")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("padqannowwmnpwwl")
    public suspend fun protectedSettingsFromKeyVault(`value`: KeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument The extensions protected settings that are passed by reference, and consumed from key vault
     */
    @JvmName("kdovrjxgwlpuxbgb")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend KeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("yqwktnuwpwkfmimk")
    public suspend fun provisionAfterExtensions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param values Collection of extension names after which this extension needs to be provisioned.
     */
    @JvmName("hrlltiqpmrvfnccn")
    public suspend fun provisionAfterExtensions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisionAfterExtensions = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("dyqypjljibybursv")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iptvkeuysiowowsy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Json formatted public settings for the extension.
     */
    @JvmName("ciasxvqmnahunhqf")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Indicates whether failures stemming from the extension will be suppressed (Operational failures such as not connecting to the VM will not be suppressed regardless of this value). The default is false.
     */
    @JvmName("ckepegwobbgkgewi")
    public suspend fun suppressFailures(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suppressFailures = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("cqnuaqoobueehauf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("rhivivncvwopnykj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies the type of the extension; an example is "CustomScriptExtension".
     */
    @JvmName("jcwbskpxfimdgadb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the script handler.
     */
    @JvmName("tvkutlkqeupjedud")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    /**
     * @param value The name of the virtual machine extension.
     */
    @JvmName("qycajpgauanxuvuc")
    public suspend fun vmExtensionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmExtensionName = mapped
    }

    /**
     * @param value The name of the virtual machine where the extension should be created or updated.
     */
    @JvmName("jkxeimhcmaikebfd")
    public suspend fun vmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmName = mapped
    }

    internal fun build(): VirtualMachineExtensionArgs = VirtualMachineExtensionArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        enableAutomaticUpgrade = enableAutomaticUpgrade,
        forceUpdateTag = forceUpdateTag,
        instanceView = instanceView,
        location = location,
        protectedSettings = protectedSettings,
        protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
        provisionAfterExtensions = provisionAfterExtensions,
        publisher = publisher,
        resourceGroupName = resourceGroupName,
        settings = settings,
        suppressFailures = suppressFailures,
        tags = tags,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
        vmExtensionName = vmExtensionName,
        vmName = vmName,
    )
}
