@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Update mode for the cloud service. Role instances are allocated to update domains when the service is deployed. Updates can be initiated manually in each update domain or initiated automatically in all update domains.
 * Possible Values are <br /><br />**Auto**<br /><br />**Manual** <br /><br />**Simultaneous**<br /><br />
 * If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called to apply the update. If set to Auto, the update is automatically applied to each update domain in sequence.
 */
public enum class CloudServiceUpgradeMode(
    public val javaValue: com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode> {
    Auto(com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode.Auto),
    Manual(com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode.Manual),
    Simultaneous(com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode.Simultaneous),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.CloudServiceUpgradeMode):
            CloudServiceUpgradeMode =
            CloudServiceUpgradeMode.values().first { it.javaValue == javaType }
    }
}
