@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies how the virtual machine should be created. Possible values are: **Attach.** This value is used when you are using a specialized disk to create the virtual machine. **FromImage.** This value is used when you are using an image to create the virtual machine. If you are using a platform image, you should also use the imageReference element described above. If you are using a marketplace image, you should also use the plan element previously described.
 */
public enum class DiskCreateOptionTypes(
    public val javaValue: com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes> {
    FromImage(com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes.FromImage),
    Empty(com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes.Empty),
    Attach(com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes.Attach),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.DiskCreateOptionTypes):
            DiskCreateOptionTypes = DiskCreateOptionTypes.values().first { it.javaValue == javaType }
    }
}
