@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Policy for accessing the disk via network.
 */
public enum class NetworkAccessPolicy(
    public val javaValue: com.pulumi.azurenative.compute.enums.NetworkAccessPolicy,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.NetworkAccessPolicy> {
    /**
     * The disk can be exported or uploaded to from any network.
     */
    AllowAll(com.pulumi.azurenative.compute.enums.NetworkAccessPolicy.AllowAll),

    /**
     * The disk can be exported or uploaded to using a DiskAccess resource's private endpoints.
     */
    AllowPrivate(com.pulumi.azurenative.compute.enums.NetworkAccessPolicy.AllowPrivate),

    /**
     * The disk cannot be exported.
     */
    DenyAll(com.pulumi.azurenative.compute.enums.NetworkAccessPolicy.DenyAll),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.NetworkAccessPolicy = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.NetworkAccessPolicy):
            NetworkAccessPolicy = NetworkAccessPolicy.values().first { it.javaValue == javaType }
    }
}
