@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of repair action (replace, restart, reimage) that will be used for repairing unhealthy virtual machines in the scale set. Default value is replace.
 */
public enum class RepairAction(
    public val javaValue: com.pulumi.azurenative.compute.enums.RepairAction,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.RepairAction> {
    Replace(com.pulumi.azurenative.compute.enums.RepairAction.Replace),
    Restart(com.pulumi.azurenative.compute.enums.RepairAction.Restart),
    Reimage(com.pulumi.azurenative.compute.enums.RepairAction.Reimage),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.RepairAction = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.RepairAction): RepairAction =
            RepairAction.values().first { it.javaValue == javaType }
    }
}
