@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the name of the setting to which the content applies. Possible values are: FirstLogonCommands and AutoLogon.
 */
public enum class SettingNames(
    public val javaValue: com.pulumi.azurenative.compute.enums.SettingNames,
) : ConvertibleToJava<com.pulumi.azurenative.compute.enums.SettingNames> {
    AutoLogon(com.pulumi.azurenative.compute.enums.SettingNames.AutoLogon),
    FirstLogonCommands(com.pulumi.azurenative.compute.enums.SettingNames.FirstLogonCommands),
    ;

    override fun toJava(): com.pulumi.azurenative.compute.enums.SettingNames = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.compute.enums.SettingNames): SettingNames =
            SettingNames.values().first { it.javaValue == javaType }
    }
}
