@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Contains the list of gallery applications that should be made available to the VM/VMSS
 * @property galleryApplications Specifies the gallery applications that should be made available to the VM/VMSS
 */
public data class ApplicationProfileArgs(
    public val galleryApplications: Output<List<VMGalleryApplicationArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs =
        com.pulumi.azurenative.compute.inputs.ApplicationProfileArgs.builder()
            .galleryApplications(
                galleryApplications?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationProfileArgs].
 */
@PulumiTagMarker
public class ApplicationProfileArgsBuilder internal constructor() {
    private var galleryApplications: Output<List<VMGalleryApplicationArgs>>? = null

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("rqeocfwdpkahncfy")
    public suspend fun galleryApplications(`value`: Output<List<VMGalleryApplicationArgs>>) {
        this.galleryApplications = value
    }

    @JvmName("hxiaoexdorndtscm")
    public suspend fun galleryApplications(vararg values: Output<VMGalleryApplicationArgs>) {
        this.galleryApplications = Output.all(values.asList())
    }

    /**
     * @param values Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("paxxvhxkoqwkdxju")
    public suspend fun galleryApplications(values: List<Output<VMGalleryApplicationArgs>>) {
        this.galleryApplications = Output.all(values)
    }

    /**
     * @param value Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("flmpdjxsoqcurpbw")
    public suspend fun galleryApplications(`value`: List<VMGalleryApplicationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.galleryApplications = mapped
    }

    /**
     * @param argument Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("gmvtcvomgnisqbun")
    public suspend
    fun galleryApplications(argument: List<suspend VMGalleryApplicationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VMGalleryApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleryApplications = mapped
    }

    /**
     * @param argument Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("jamkpjvdbrpyydby")
    public suspend fun galleryApplications(
        vararg
        argument: suspend VMGalleryApplicationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VMGalleryApplicationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.galleryApplications = mapped
    }

    /**
     * @param argument Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("kctlinhpdmirecym")
    public suspend
    fun galleryApplications(argument: suspend VMGalleryApplicationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VMGalleryApplicationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.galleryApplications = mapped
    }

    /**
     * @param values Specifies the gallery applications that should be made available to the VM/VMSS
     */
    @JvmName("ptxirjwsuwmckfxj")
    public suspend fun galleryApplications(vararg values: VMGalleryApplicationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.galleryApplications = mapped
    }

    internal fun build(): ApplicationProfileArgs = ApplicationProfileArgs(
        galleryApplications = galleryApplications,
    )
}
