@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceExtensionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Extension Properties.
 * @property autoUpgradeMinorVersion Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
 * @property forceUpdateTag Tag to force apply the provided public and protected settings.
 * Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
 * If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
 * If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
 * it is up to handler implementation whether to re-run it or not
 * @property protectedSettings Protected settings for the extension which are encrypted before sent to the role instance.
 * @property protectedSettingsFromKeyVault Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
 * @property publisher The name of the extension handler publisher.
 * @property rolesAppliedTo Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
 * @property settings Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
 * @property type Specifies the type of the extension.
 * @property typeHandlerVersion Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
 */
public data class CloudServiceExtensionPropertiesArgs(
    public val autoUpgradeMinorVersion: Output<Boolean>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val protectedSettings: Output<Any>? = null,
    public val protectedSettingsFromKeyVault: Output<CloudServiceVaultAndSecretReferenceArgs>? = null,
    public val publisher: Output<String>? = null,
    public val rolesAppliedTo: Output<List<String>>? = null,
    public val settings: Output<Any>? = null,
    public val type: Output<String>? = null,
    public val typeHandlerVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceExtensionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceExtensionPropertiesArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceExtensionPropertiesArgs.builder()
            .autoUpgradeMinorVersion(autoUpgradeMinorVersion?.applyValue({ args0 -> args0 }))
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .protectedSettings(protectedSettings?.applyValue({ args0 -> args0 }))
            .protectedSettingsFromKeyVault(
                protectedSettingsFromKeyVault?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .rolesAppliedTo(rolesAppliedTo?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .settings(settings?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .typeHandlerVersion(typeHandlerVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudServiceExtensionPropertiesArgs].
 */
@PulumiTagMarker
public class CloudServiceExtensionPropertiesArgsBuilder internal constructor() {
    private var autoUpgradeMinorVersion: Output<Boolean>? = null

    private var forceUpdateTag: Output<String>? = null

    private var protectedSettings: Output<Any>? = null

    private var protectedSettingsFromKeyVault: Output<CloudServiceVaultAndSecretReferenceArgs>? = null

    private var publisher: Output<String>? = null

    private var rolesAppliedTo: Output<List<String>>? = null

    private var settings: Output<Any>? = null

    private var type: Output<String>? = null

    private var typeHandlerVersion: Output<String>? = null

    /**
     * @param value Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
     */
    @JvmName("inkmwjrlxogeiqga")
    public suspend fun autoUpgradeMinorVersion(`value`: Output<Boolean>) {
        this.autoUpgradeMinorVersion = value
    }

    /**
     * @param value Tag to force apply the provided public and protected settings.
     * Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
     * If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
     * If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
     * it is up to handler implementation whether to re-run it or not
     */
    @JvmName("wfvycxbguqcanfsw")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value Protected settings for the extension which are encrypted before sent to the role instance.
     */
    @JvmName("llakbjuyjamnyasd")
    public suspend fun protectedSettings(`value`: Output<Any>) {
        this.protectedSettings = value
    }

    /**
     * @param value Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
     */
    @JvmName("iilltolaeaccriwq")
    public suspend
    fun protectedSettingsFromKeyVault(`value`: Output<CloudServiceVaultAndSecretReferenceArgs>) {
        this.protectedSettingsFromKeyVault = value
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("emfbrpbysjmnyofs")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
     */
    @JvmName("ampbbeyivfhqppql")
    public suspend fun rolesAppliedTo(`value`: Output<List<String>>) {
        this.rolesAppliedTo = value
    }

    @JvmName("pnmdyuprsnpgnwbl")
    public suspend fun rolesAppliedTo(vararg values: Output<String>) {
        this.rolesAppliedTo = Output.all(values.asList())
    }

    /**
     * @param values Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
     */
    @JvmName("dnunwgclwyncasvg")
    public suspend fun rolesAppliedTo(values: List<Output<String>>) {
        this.rolesAppliedTo = Output.all(values)
    }

    /**
     * @param value Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
     */
    @JvmName("jubmcgrruvngmbeo")
    public suspend fun settings(`value`: Output<Any>) {
        this.settings = value
    }

    /**
     * @param value Specifies the type of the extension.
     */
    @JvmName("tiikskgxqffxncdb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
     */
    @JvmName("qdajvabocywvoudp")
    public suspend fun typeHandlerVersion(`value`: Output<String>) {
        this.typeHandlerVersion = value
    }

    /**
     * @param value Explicitly specify whether platform can automatically upgrade typeHandlerVersion to higher minor versions when they become available.
     */
    @JvmName("wfremvnspgwiurcr")
    public suspend fun autoUpgradeMinorVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUpgradeMinorVersion = mapped
    }

    /**
     * @param value Tag to force apply the provided public and protected settings.
     * Changing the tag value allows for re-running the extension without changing any of the public or protected settings.
     * If forceUpdateTag is not changed, updates to public or protected settings would still be applied by the handler.
     * If neither forceUpdateTag nor any of public or protected settings change, extension would flow to the role instance with the same sequence-number, and
     * it is up to handler implementation whether to re-run it or not
     */
    @JvmName("rgebphxjggniufiv")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value Protected settings for the extension which are encrypted before sent to the role instance.
     */
    @JvmName("wsfgvganptxlsfrk")
    public suspend fun protectedSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettings = mapped
    }

    /**
     * @param value Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
     */
    @JvmName("roadvmikwqdmeirc")
    public suspend
    fun protectedSettingsFromKeyVault(`value`: CloudServiceVaultAndSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param argument Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
     */
    @JvmName("wqblddubthrthbkv")
    public suspend
    fun protectedSettingsFromKeyVault(argument: suspend CloudServiceVaultAndSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceVaultAndSecretReferenceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.protectedSettingsFromKeyVault = mapped
    }

    /**
     * @param value The name of the extension handler publisher.
     */
    @JvmName("vnebgasqnwdbkprk")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
     */
    @JvmName("tosgnjblrxqdsius")
    public suspend fun rolesAppliedTo(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rolesAppliedTo = mapped
    }

    /**
     * @param values Optional list of roles to apply this extension. If property is not specified or '*' is specified, extension is applied to all roles in the cloud service.
     */
    @JvmName("ifxsnkwogojyuvrg")
    public suspend fun rolesAppliedTo(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rolesAppliedTo = mapped
    }

    /**
     * @param value Public settings for the extension. For JSON extensions, this is the JSON settings for the extension. For XML Extension (like RDP), this is the XML setting for the extension.
     */
    @JvmName("ihqapxfkbjypewwy")
    public suspend fun settings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param value Specifies the type of the extension.
     */
    @JvmName("olftkwiksakggehh")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies the version of the extension. Specifies the version of the extension. If this element is not specified or an asterisk (*) is used as the value, the latest version of the extension is used. If the value is specified with a major version number and an asterisk as the minor version number (X.), the latest minor version of the specified major version is selected. If a major version number and a minor version number are specified (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade is performed on the role instance.
     */
    @JvmName("jufqwdywvrecpfih")
    public suspend fun typeHandlerVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.typeHandlerVersion = mapped
    }

    internal fun build(): CloudServiceExtensionPropertiesArgs = CloudServiceExtensionPropertiesArgs(
        autoUpgradeMinorVersion = autoUpgradeMinorVersion,
        forceUpdateTag = forceUpdateTag,
        protectedSettings = protectedSettings,
        protectedSettingsFromKeyVault = protectedSettingsFromKeyVault,
        publisher = publisher,
        rolesAppliedTo = rolesAppliedTo,
        settings = settings,
        type = type,
        typeHandlerVersion = typeHandlerVersion,
    )
}
