@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the role properties.
 * @property name Resource name.
 * @property sku Describes the cloud service role sku.
 */
public data class CloudServiceRoleProfilePropertiesArgs(
    public val name: Output<String>? = null,
    public val sku: Output<CloudServiceRoleSkuArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfilePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfilePropertiesArgs =
        com.pulumi.azurenative.compute.inputs.CloudServiceRoleProfilePropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [CloudServiceRoleProfilePropertiesArgs].
 */
@PulumiTagMarker
public class CloudServiceRoleProfilePropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sku: Output<CloudServiceRoleSkuArgs>? = null

    /**
     * @param value Resource name.
     */
    @JvmName("bpnefaswcmflnylh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Describes the cloud service role sku.
     */
    @JvmName("cilxauujhxgtpubi")
    public suspend fun sku(`value`: Output<CloudServiceRoleSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource name.
     */
    @JvmName("xauwvtipjlnbkagm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Describes the cloud service role sku.
     */
    @JvmName("pmkdderluwfepaon")
    public suspend fun sku(`value`: CloudServiceRoleSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Describes the cloud service role sku.
     */
    @JvmName("euiwkoqdisgmodka")
    public suspend fun sku(argument: suspend CloudServiceRoleSkuArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceRoleSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    internal fun build(): CloudServiceRoleProfilePropertiesArgs =
        CloudServiceRoleProfilePropertiesArgs(
            name = name,
            sku = sku,
        )
}
