@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.DiskSecurityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains the security related information for the resource.
 * @property secureVMDiskEncryptionSetId ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
 * @property securityType Specifies the SecurityType of the VM. Applicable for OS disks only.
 */
public data class DiskSecurityProfileArgs(
    public val secureVMDiskEncryptionSetId: Output<String>? = null,
    public val securityType: Output<Either<String, DiskSecurityTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs =
        com.pulumi.azurenative.compute.inputs.DiskSecurityProfileArgs.builder()
            .secureVMDiskEncryptionSetId(secureVMDiskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .securityType(
                securityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DiskSecurityProfileArgs].
 */
@PulumiTagMarker
public class DiskSecurityProfileArgsBuilder internal constructor() {
    private var secureVMDiskEncryptionSetId: Output<String>? = null

    private var securityType: Output<Either<String, DiskSecurityTypes>>? = null

    /**
     * @param value ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
     */
    @JvmName("dfwuqvoypeubexlt")
    public suspend fun secureVMDiskEncryptionSetId(`value`: Output<String>) {
        this.secureVMDiskEncryptionSetId = value
    }

    /**
     * @param value Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    @JvmName("uxtblvcfjnvjdklq")
    public suspend fun securityType(`value`: Output<Either<String, DiskSecurityTypes>>) {
        this.securityType = value
    }

    /**
     * @param value ResourceId of the disk encryption set associated to Confidential VM supported disk encrypted with customer managed key
     */
    @JvmName("bqnmvnltxjskbelh")
    public suspend fun secureVMDiskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureVMDiskEncryptionSetId = mapped
    }

    /**
     * @param value Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    @JvmName("dykcrsraeufywsma")
    public suspend fun securityType(`value`: Either<String, DiskSecurityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    @JvmName("htrydogdakypwarv")
    public fun securityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskSecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the SecurityType of the VM. Applicable for OS disks only.
     */
    @JvmName("wysufbvyxjspawca")
    public fun securityType(`value`: DiskSecurityTypes) {
        val toBeMapped = Either.ofRight<String, DiskSecurityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    internal fun build(): DiskSecurityProfileArgs = DiskSecurityProfileArgs(
        secureVMDiskEncryptionSetId = secureVMDiskEncryptionSetId,
        securityType = securityType,
    )
}
