@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.EncryptionImagesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.
 * @property dataDiskImages A list of encryption specifications for data disk images.
 * @property osDiskImage Contains encryption settings for an OS disk image.
 */
public data class EncryptionImagesArgs(
    public val dataDiskImages: Output<List<DataDiskImageEncryptionArgs>>? = null,
    public val osDiskImage: Output<OSDiskImageEncryptionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.EncryptionImagesArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.EncryptionImagesArgs =
        com.pulumi.azurenative.compute.inputs.EncryptionImagesArgs.builder()
            .dataDiskImages(
                dataDiskImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osDiskImage(osDiskImage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionImagesArgs].
 */
@PulumiTagMarker
public class EncryptionImagesArgsBuilder internal constructor() {
    private var dataDiskImages: Output<List<DataDiskImageEncryptionArgs>>? = null

    private var osDiskImage: Output<OSDiskImageEncryptionArgs>? = null

    /**
     * @param value A list of encryption specifications for data disk images.
     */
    @JvmName("delvefyrmoigsaul")
    public suspend fun dataDiskImages(`value`: Output<List<DataDiskImageEncryptionArgs>>) {
        this.dataDiskImages = value
    }

    @JvmName("muigxqukjmwxkumg")
    public suspend fun dataDiskImages(vararg values: Output<DataDiskImageEncryptionArgs>) {
        this.dataDiskImages = Output.all(values.asList())
    }

    /**
     * @param values A list of encryption specifications for data disk images.
     */
    @JvmName("hvhoqlxixopvtevl")
    public suspend fun dataDiskImages(values: List<Output<DataDiskImageEncryptionArgs>>) {
        this.dataDiskImages = Output.all(values)
    }

    /**
     * @param value Contains encryption settings for an OS disk image.
     */
    @JvmName("yxyvbfbijwsuqwlu")
    public suspend fun osDiskImage(`value`: Output<OSDiskImageEncryptionArgs>) {
        this.osDiskImage = value
    }

    /**
     * @param value A list of encryption specifications for data disk images.
     */
    @JvmName("tqgsnicunojsxfnx")
    public suspend fun dataDiskImages(`value`: List<DataDiskImageEncryptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of encryption specifications for data disk images.
     */
    @JvmName("thsgwqgnxqcctjnp")
    public suspend
    fun dataDiskImages(argument: List<suspend DataDiskImageEncryptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataDiskImageEncryptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of encryption specifications for data disk images.
     */
    @JvmName("qokfwahwjtbreieo")
    public suspend fun dataDiskImages(
        vararg
        argument: suspend DataDiskImageEncryptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DataDiskImageEncryptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of encryption specifications for data disk images.
     */
    @JvmName("huxgtcixnqsamwoe")
    public suspend
    fun dataDiskImages(argument: suspend DataDiskImageEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataDiskImageEncryptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param values A list of encryption specifications for data disk images.
     */
    @JvmName("heaqlujrggnaysff")
    public suspend fun dataDiskImages(vararg values: DataDiskImageEncryptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskImages = mapped
    }

    /**
     * @param value Contains encryption settings for an OS disk image.
     */
    @JvmName("uybsfakpbopywyjq")
    public suspend fun osDiskImage(`value`: OSDiskImageEncryptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskImage = mapped
    }

    /**
     * @param argument Contains encryption settings for an OS disk image.
     */
    @JvmName("vxlgtvfqomfrsvpp")
    public suspend fun osDiskImage(argument: suspend OSDiskImageEncryptionArgsBuilder.() -> Unit) {
        val toBeMapped = OSDiskImageEncryptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDiskImage = mapped
    }

    internal fun build(): EncryptionImagesArgs = EncryptionImagesArgs(
        dataDiskImages = dataDiskImages,
        osDiskImage = osDiskImage,
    )
}
