@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.EncryptionSettingsElementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Encryption settings for one disk volume.
 * @property diskEncryptionKey Key Vault Secret Url and vault id of the disk encryption key
 * @property keyEncryptionKey Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
 */
public data class EncryptionSettingsElementArgs(
    public val diskEncryptionKey: Output<KeyVaultAndSecretReferenceArgs>? = null,
    public val keyEncryptionKey: Output<KeyVaultAndKeyReferenceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.EncryptionSettingsElementArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.EncryptionSettingsElementArgs =
        com.pulumi.azurenative.compute.inputs.EncryptionSettingsElementArgs.builder()
            .diskEncryptionKey(diskEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyEncryptionKey(
                keyEncryptionKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionSettingsElementArgs].
 */
@PulumiTagMarker
public class EncryptionSettingsElementArgsBuilder internal constructor() {
    private var diskEncryptionKey: Output<KeyVaultAndSecretReferenceArgs>? = null

    private var keyEncryptionKey: Output<KeyVaultAndKeyReferenceArgs>? = null

    /**
     * @param value Key Vault Secret Url and vault id of the disk encryption key
     */
    @JvmName("uysmsnlxdjtuwjtp")
    public suspend fun diskEncryptionKey(`value`: Output<KeyVaultAndSecretReferenceArgs>) {
        this.diskEncryptionKey = value
    }

    /**
     * @param value Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
     */
    @JvmName("fcnptgdjwhwluvyx")
    public suspend fun keyEncryptionKey(`value`: Output<KeyVaultAndKeyReferenceArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Key Vault Secret Url and vault id of the disk encryption key
     */
    @JvmName("tqekqeutlrplfcyf")
    public suspend fun diskEncryptionKey(`value`: KeyVaultAndSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionKey = mapped
    }

    /**
     * @param argument Key Vault Secret Url and vault id of the disk encryption key
     */
    @JvmName("sxfhuyatcbpffyop")
    public suspend
    fun diskEncryptionKey(argument: suspend KeyVaultAndSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultAndSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskEncryptionKey = mapped
    }

    /**
     * @param value Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
     */
    @JvmName("rjmgfsryylkjuhma")
    public suspend fun keyEncryptionKey(`value`: KeyVaultAndKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Key Vault Key Url and vault id of the key encryption key. KeyEncryptionKey is optional and when provided is used to unwrap the disk encryption key.
     */
    @JvmName("xilgrmhcyvqljifk")
    public suspend
    fun keyEncryptionKey(argument: suspend KeyVaultAndKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultAndKeyReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    internal fun build(): EncryptionSettingsElementArgs = EncryptionSettingsElementArgs(
        diskEncryptionKey = diskEncryptionKey,
        keyEncryptionKey = keyEncryptionKey,
    )
}
