@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.ExtensionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a cloud service Extension.
 * @property name The name of the extension.
 * @property properties Extension Properties.
 */
public data class ExtensionArgs(
    public val name: Output<String>? = null,
    public val properties: Output<CloudServiceExtensionPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.ExtensionArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.ExtensionArgs =
        com.pulumi.azurenative.compute.inputs.ExtensionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ExtensionArgs].
 */
@PulumiTagMarker
public class ExtensionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var properties: Output<CloudServiceExtensionPropertiesArgs>? = null

    /**
     * @param value The name of the extension.
     */
    @JvmName("bxvivitoostvndlg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Extension Properties.
     */
    @JvmName("tjjebgttrufvaqfn")
    public suspend fun properties(`value`: Output<CloudServiceExtensionPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the extension.
     */
    @JvmName("wtxmcdkicrqbnpky")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Extension Properties.
     */
    @JvmName("yjouqwdiqbpohmxf")
    public suspend fun properties(`value`: CloudServiceExtensionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Extension Properties.
     */
    @JvmName("ymdbucycrduaomuu")
    public suspend
    fun properties(argument: suspend CloudServiceExtensionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CloudServiceExtensionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): ExtensionArgs = ExtensionArgs(
        name = name,
        properties = properties,
    )
}
