@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionPublishingProfileArgs.builder
import com.pulumi.azurenative.compute.kotlin.enums.ReplicationMode
import com.pulumi.azurenative.compute.kotlin.enums.StorageAccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The publishing profile of a gallery image version.
 * @property advancedSettings Optional. Additional settings to pass to the vm-application-manager extension. For advanced use only.
 * @property customActions A list of custom actions that can be performed with this Gallery Application Version.
 * @property enableHealthCheck Optional. Whether or not this application reports health.
 * @property endOfLifeDate The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
 * @property excludeFromLatest If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
 * @property manageActions
 * @property replicaCount The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
 * @property replicationMode Optional parameter which specifies the mode to be used for replication. This property is not updatable.
 * @property settings Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
 * @property source The source image from which the Image Version is going to be created.
 * @property storageAccountType Specifies the storage account type to be used to store the image. This property is not updatable.
 * @property targetExtendedLocations The target extended locations where the Image Version is going to be replicated to. This property is updatable.
 * @property targetRegions The target regions where the Image Version is going to be replicated to. This property is updatable.
 */
public data class GalleryApplicationVersionPublishingProfileArgs(
    public val advancedSettings: Output<Map<String, String>>? = null,
    public val customActions: Output<List<GalleryApplicationCustomActionArgs>>? = null,
    public val enableHealthCheck: Output<Boolean>? = null,
    public val endOfLifeDate: Output<String>? = null,
    public val excludeFromLatest: Output<Boolean>? = null,
    public val manageActions: Output<UserArtifactManageArgs>? = null,
    public val replicaCount: Output<Int>? = null,
    public val replicationMode: Output<Either<String, ReplicationMode>>? = null,
    public val settings: Output<UserArtifactSettingsArgs>? = null,
    public val source: Output<UserArtifactSourceArgs>,
    public val storageAccountType: Output<Either<String, StorageAccountType>>? = null,
    public val targetExtendedLocations: Output<List<GalleryTargetExtendedLocationArgs>>? = null,
    public val targetRegions: Output<List<TargetRegionArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionPublishingProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionPublishingProfileArgs =
        com.pulumi.azurenative.compute.inputs.GalleryApplicationVersionPublishingProfileArgs.builder()
            .advancedSettings(
                advancedSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .customActions(
                customActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .enableHealthCheck(enableHealthCheck?.applyValue({ args0 -> args0 }))
            .endOfLifeDate(endOfLifeDate?.applyValue({ args0 -> args0 }))
            .excludeFromLatest(excludeFromLatest?.applyValue({ args0 -> args0 }))
            .manageActions(manageActions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .replicaCount(replicaCount?.applyValue({ args0 -> args0 }))
            .replicationMode(
                replicationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .settings(settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .source(source.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageAccountType(
                storageAccountType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .targetExtendedLocations(
                targetExtendedLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .targetRegions(
                targetRegions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GalleryApplicationVersionPublishingProfileArgs].
 */
@PulumiTagMarker
public class GalleryApplicationVersionPublishingProfileArgsBuilder internal constructor() {
    private var advancedSettings: Output<Map<String, String>>? = null

    private var customActions: Output<List<GalleryApplicationCustomActionArgs>>? = null

    private var enableHealthCheck: Output<Boolean>? = null

    private var endOfLifeDate: Output<String>? = null

    private var excludeFromLatest: Output<Boolean>? = null

    private var manageActions: Output<UserArtifactManageArgs>? = null

    private var replicaCount: Output<Int>? = null

    private var replicationMode: Output<Either<String, ReplicationMode>>? = null

    private var settings: Output<UserArtifactSettingsArgs>? = null

    private var source: Output<UserArtifactSourceArgs>? = null

    private var storageAccountType: Output<Either<String, StorageAccountType>>? = null

    private var targetExtendedLocations: Output<List<GalleryTargetExtendedLocationArgs>>? = null

    private var targetRegions: Output<List<TargetRegionArgs>>? = null

    /**
     * @param value Optional. Additional settings to pass to the vm-application-manager extension. For advanced use only.
     */
    @JvmName("vreduansqjumouyj")
    public suspend fun advancedSettings(`value`: Output<Map<String, String>>) {
        this.advancedSettings = value
    }

    /**
     * @param value A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("wtebchgaxkedfhll")
    public suspend fun customActions(`value`: Output<List<GalleryApplicationCustomActionArgs>>) {
        this.customActions = value
    }

    @JvmName("lghqbrixbgkyvfdj")
    public suspend fun customActions(vararg values: Output<GalleryApplicationCustomActionArgs>) {
        this.customActions = Output.all(values.asList())
    }

    /**
     * @param values A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("pqlyaoitdgyhshhs")
    public suspend fun customActions(values: List<Output<GalleryApplicationCustomActionArgs>>) {
        this.customActions = Output.all(values)
    }

    /**
     * @param value Optional. Whether or not this application reports health.
     */
    @JvmName("ycivrgfsnawnxdpv")
    public suspend fun enableHealthCheck(`value`: Output<Boolean>) {
        this.enableHealthCheck = value
    }

    /**
     * @param value The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("cagbdmmhamixtypy")
    public suspend fun endOfLifeDate(`value`: Output<String>) {
        this.endOfLifeDate = value
    }

    /**
     * @param value If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
     */
    @JvmName("mwdiikaxwxlmvwun")
    public suspend fun excludeFromLatest(`value`: Output<Boolean>) {
        this.excludeFromLatest = value
    }

    /**
     * @param value
     */
    @JvmName("lxkfaurfwvuunaym")
    public suspend fun manageActions(`value`: Output<UserArtifactManageArgs>) {
        this.manageActions = value
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
     */
    @JvmName("urbjcuacaiicrqof")
    public suspend fun replicaCount(`value`: Output<Int>) {
        this.replicaCount = value
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("ijagyotwthishlij")
    public suspend fun replicationMode(`value`: Output<Either<String, ReplicationMode>>) {
        this.replicationMode = value
    }

    /**
     * @param value Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
     */
    @JvmName("lurlcmyiajpskcao")
    public suspend fun settings(`value`: Output<UserArtifactSettingsArgs>) {
        this.settings = value
    }

    /**
     * @param value The source image from which the Image Version is going to be created.
     */
    @JvmName("rovgrbqfecrpslbk")
    public suspend fun source(`value`: Output<UserArtifactSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("bvkyruvrigxslxtt")
    public suspend fun storageAccountType(`value`: Output<Either<String, StorageAccountType>>) {
        this.storageAccountType = value
    }

    /**
     * @param value The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("kalvfdyvonxklsda")
    public suspend
    fun targetExtendedLocations(`value`: Output<List<GalleryTargetExtendedLocationArgs>>) {
        this.targetExtendedLocations = value
    }

    @JvmName("qgpelyxymkanqimg")
    public suspend fun targetExtendedLocations(
        vararg
        values: Output<GalleryTargetExtendedLocationArgs>,
    ) {
        this.targetExtendedLocations = Output.all(values.asList())
    }

    /**
     * @param values The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("orvyxgkykrlrjoew")
    public suspend
    fun targetExtendedLocations(values: List<Output<GalleryTargetExtendedLocationArgs>>) {
        this.targetExtendedLocations = Output.all(values)
    }

    /**
     * @param value The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("lusiexqgndbnftwq")
    public suspend fun targetRegions(`value`: Output<List<TargetRegionArgs>>) {
        this.targetRegions = value
    }

    @JvmName("ybrlgmvgadqucjdq")
    public suspend fun targetRegions(vararg values: Output<TargetRegionArgs>) {
        this.targetRegions = Output.all(values.asList())
    }

    /**
     * @param values The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("atqdyxiqvrhefhrf")
    public suspend fun targetRegions(values: List<Output<TargetRegionArgs>>) {
        this.targetRegions = Output.all(values)
    }

    /**
     * @param value Optional. Additional settings to pass to the vm-application-manager extension. For advanced use only.
     */
    @JvmName("nrjvbyitrpvrrsvy")
    public suspend fun advancedSettings(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedSettings = mapped
    }

    /**
     * @param values Optional. Additional settings to pass to the vm-application-manager extension. For advanced use only.
     */
    @JvmName("mugjbvgykdgnssvb")
    public fun advancedSettings(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advancedSettings = mapped
    }

    /**
     * @param value A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("meippxmnwdpxusii")
    public suspend fun customActions(`value`: List<GalleryApplicationCustomActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("lyfmogurxaatayfv")
    public suspend
    fun customActions(argument: List<suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("sqhjrkblctaoofbb")
    public suspend fun customActions(
        vararg
        argument: suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryApplicationCustomActionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param argument A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("kyculmfguyocfqoh")
    public suspend
    fun customActions(argument: suspend GalleryApplicationCustomActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GalleryApplicationCustomActionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.customActions = mapped
    }

    /**
     * @param values A list of custom actions that can be performed with this Gallery Application Version.
     */
    @JvmName("sqekswwslkdmbjxy")
    public suspend fun customActions(vararg values: GalleryApplicationCustomActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customActions = mapped
    }

    /**
     * @param value Optional. Whether or not this application reports health.
     */
    @JvmName("bqmnlrnhcjalwbdn")
    public suspend fun enableHealthCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableHealthCheck = mapped
    }

    /**
     * @param value The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.
     */
    @JvmName("uidsnujbhoxmpwps")
    public suspend fun endOfLifeDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endOfLifeDate = mapped
    }

    /**
     * @param value If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.
     */
    @JvmName("ghprdaoehithdqrq")
    public suspend fun excludeFromLatest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeFromLatest = mapped
    }

    /**
     * @param value
     */
    @JvmName("jlwcjxvdjylrdgbj")
    public suspend fun manageActions(`value`: UserArtifactManageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manageActions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bsqngcpuvvvuuksr")
    public suspend fun manageActions(argument: suspend UserArtifactManageArgsBuilder.() -> Unit) {
        val toBeMapped = UserArtifactManageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.manageActions = mapped
    }

    /**
     * @param value The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.
     */
    @JvmName("dlokgdgjuyrbqcxg")
    public suspend fun replicaCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicaCount = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("haeoudsjkladpxuq")
    public suspend fun replicationMode(`value`: Either<String, ReplicationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("sypoxqwejbumprej")
    public fun replicationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Optional parameter which specifies the mode to be used for replication. This property is not updatable.
     */
    @JvmName("fleumbxoxicaltxb")
    public fun replicationMode(`value`: ReplicationMode) {
        val toBeMapped = Either.ofRight<String, ReplicationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationMode = mapped
    }

    /**
     * @param value Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
     */
    @JvmName("laxhddusrribxeiu")
    public suspend fun settings(`value`: UserArtifactSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Additional settings for the VM app that contains the target package and config file name when it is deployed to target VM or VM scale set.
     */
    @JvmName("yeqvecgihybmijed")
    public suspend fun settings(argument: suspend UserArtifactSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserArtifactSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param value The source image from which the Image Version is going to be created.
     */
    @JvmName("nvimfrmsotqomiks")
    public suspend fun source(`value`: UserArtifactSourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source image from which the Image Version is going to be created.
     */
    @JvmName("cfevypmpuktlqkic")
    public suspend fun source(argument: suspend UserArtifactSourceArgsBuilder.() -> Unit) {
        val toBeMapped = UserArtifactSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("sckgxmrxpmnbohaw")
    public suspend fun storageAccountType(`value`: Either<String, StorageAccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("rxagdfrvnksfnicw")
    public fun storageAccountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value Specifies the storage account type to be used to store the image. This property is not updatable.
     */
    @JvmName("ifmdwulofjybrmab")
    public fun storageAccountType(`value`: StorageAccountType) {
        val toBeMapped = Either.ofRight<String, StorageAccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountType = mapped
    }

    /**
     * @param value The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("oivkvbyuhmckaqsc")
    public suspend fun targetExtendedLocations(`value`: List<GalleryTargetExtendedLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("ksjmdjwcprhmpeqy")
    public suspend
    fun targetExtendedLocations(argument: List<suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryTargetExtendedLocationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("tbjbhmjxrigpsyai")
    public suspend fun targetExtendedLocations(
        vararg
        argument: suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryTargetExtendedLocationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param argument The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("cfrlirqieblapvqi")
    public suspend
    fun targetExtendedLocations(argument: suspend GalleryTargetExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GalleryTargetExtendedLocationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.targetExtendedLocations = mapped
    }

    /**
     * @param values The target extended locations where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("gnpdeltbglaacjyj")
    public suspend fun targetExtendedLocations(vararg values: GalleryTargetExtendedLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetExtendedLocations = mapped
    }

    /**
     * @param value The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("ojglutnfgekehgdi")
    public suspend fun targetRegions(`value`: List<TargetRegionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("yhssgtjeyonidwno")
    public suspend fun targetRegions(argument: List<suspend TargetRegionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("bdcfaarkniwnbscw")
    public suspend fun targetRegions(vararg argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TargetRegionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param argument The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("ygrgwnswblxotwvl")
    public suspend fun targetRegions(argument: suspend TargetRegionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TargetRegionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.targetRegions = mapped
    }

    /**
     * @param values The target regions where the Image Version is going to be replicated to. This property is updatable.
     */
    @JvmName("liorgrppjwcnvqdk")
    public suspend fun targetRegions(vararg values: TargetRegionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRegions = mapped
    }

    internal fun build(): GalleryApplicationVersionPublishingProfileArgs =
        GalleryApplicationVersionPublishingProfileArgs(
            advancedSettings = advancedSettings,
            customActions = customActions,
            enableHealthCheck = enableHealthCheck,
            endOfLifeDate = endOfLifeDate,
            excludeFromLatest = excludeFromLatest,
            manageActions = manageActions,
            replicaCount = replicaCount,
            replicationMode = replicationMode,
            settings = settings,
            source = source ?: throw PulumiNullFieldException("source"),
            storageAccountType = storageAccountType,
            targetExtendedLocations = targetExtendedLocations,
            targetRegions = targetRegions,
        )
}
