@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryArtifactVersionFullSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The source of the gallery artifact version.
 * @property communityGalleryImageId The resource Id of the source Community Gallery Image.  Only required when using Community Gallery Image as a source.
 * @property id The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
 */
public data class GalleryArtifactVersionFullSourceArgs(
    public val communityGalleryImageId: Output<String>? = null,
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryArtifactVersionFullSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryArtifactVersionFullSourceArgs =
        com.pulumi.azurenative.compute.inputs.GalleryArtifactVersionFullSourceArgs.builder()
            .communityGalleryImageId(communityGalleryImageId?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryArtifactVersionFullSourceArgs].
 */
@PulumiTagMarker
public class GalleryArtifactVersionFullSourceArgsBuilder internal constructor() {
    private var communityGalleryImageId: Output<String>? = null

    private var id: Output<String>? = null

    /**
     * @param value The resource Id of the source Community Gallery Image.  Only required when using Community Gallery Image as a source.
     */
    @JvmName("uohuwuiqqqnmbxiq")
    public suspend fun communityGalleryImageId(`value`: Output<String>) {
        this.communityGalleryImageId = value
    }

    /**
     * @param value The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
     */
    @JvmName("ahdgsjpkuwbmogdo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The resource Id of the source Community Gallery Image.  Only required when using Community Gallery Image as a source.
     */
    @JvmName("fbpcmnbpbonoyivw")
    public suspend fun communityGalleryImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityGalleryImageId = mapped
    }

    /**
     * @param value The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.
     */
    @JvmName("ghlihiumbqvkuxah")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): GalleryArtifactVersionFullSourceArgs = GalleryArtifactVersionFullSourceArgs(
        communityGalleryImageId = communityGalleryImageId,
        id = id,
    )
}
