@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GalleryImageVersionStorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * This is the storage profile of a Gallery Image Version.
 * @property dataDiskImages A list of data disk images.
 * @property osDiskImage This is the OS disk image.
 * @property source The source of the gallery artifact version.
 */
public data class GalleryImageVersionStorageProfileArgs(
    public val dataDiskImages: Output<List<GalleryDataDiskImageArgs>>? = null,
    public val osDiskImage: Output<GalleryOSDiskImageArgs>? = null,
    public val source: Output<GalleryArtifactVersionFullSourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GalleryImageVersionStorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GalleryImageVersionStorageProfileArgs =
        com.pulumi.azurenative.compute.inputs.GalleryImageVersionStorageProfileArgs.builder()
            .dataDiskImages(
                dataDiskImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .osDiskImage(osDiskImage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GalleryImageVersionStorageProfileArgs].
 */
@PulumiTagMarker
public class GalleryImageVersionStorageProfileArgsBuilder internal constructor() {
    private var dataDiskImages: Output<List<GalleryDataDiskImageArgs>>? = null

    private var osDiskImage: Output<GalleryOSDiskImageArgs>? = null

    private var source: Output<GalleryArtifactVersionFullSourceArgs>? = null

    /**
     * @param value A list of data disk images.
     */
    @JvmName("jsnuufipylcdkbes")
    public suspend fun dataDiskImages(`value`: Output<List<GalleryDataDiskImageArgs>>) {
        this.dataDiskImages = value
    }

    @JvmName("nwvovjvbxwxegbns")
    public suspend fun dataDiskImages(vararg values: Output<GalleryDataDiskImageArgs>) {
        this.dataDiskImages = Output.all(values.asList())
    }

    /**
     * @param values A list of data disk images.
     */
    @JvmName("dkbfywgcarslvrfa")
    public suspend fun dataDiskImages(values: List<Output<GalleryDataDiskImageArgs>>) {
        this.dataDiskImages = Output.all(values)
    }

    /**
     * @param value This is the OS disk image.
     */
    @JvmName("nxxoauivtdwvcxfd")
    public suspend fun osDiskImage(`value`: Output<GalleryOSDiskImageArgs>) {
        this.osDiskImage = value
    }

    /**
     * @param value The source of the gallery artifact version.
     */
    @JvmName("aoqoasfemtwdphwj")
    public suspend fun source(`value`: Output<GalleryArtifactVersionFullSourceArgs>) {
        this.source = value
    }

    /**
     * @param value A list of data disk images.
     */
    @JvmName("tqnexryxscxjtmxp")
    public suspend fun dataDiskImages(`value`: List<GalleryDataDiskImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of data disk images.
     */
    @JvmName("bddjerdaiyxpunxk")
    public suspend
    fun dataDiskImages(argument: List<suspend GalleryDataDiskImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GalleryDataDiskImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of data disk images.
     */
    @JvmName("lxtfdsutjacymuve")
    public suspend fun dataDiskImages(
        vararg
        argument: suspend GalleryDataDiskImageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GalleryDataDiskImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param argument A list of data disk images.
     */
    @JvmName("piouyfiaumexbwfm")
    public suspend fun dataDiskImages(argument: suspend GalleryDataDiskImageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GalleryDataDiskImageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dataDiskImages = mapped
    }

    /**
     * @param values A list of data disk images.
     */
    @JvmName("srbnwjaeadggiyrc")
    public suspend fun dataDiskImages(vararg values: GalleryDataDiskImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskImages = mapped
    }

    /**
     * @param value This is the OS disk image.
     */
    @JvmName("svhiesyhgfhsnnbb")
    public suspend fun osDiskImage(`value`: GalleryOSDiskImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osDiskImage = mapped
    }

    /**
     * @param argument This is the OS disk image.
     */
    @JvmName("lnnoysfvppiaygdn")
    public suspend fun osDiskImage(argument: suspend GalleryOSDiskImageArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryOSDiskImageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDiskImage = mapped
    }

    /**
     * @param value The source of the gallery artifact version.
     */
    @JvmName("xrwnnncmpuhhnysy")
    public suspend fun source(`value`: GalleryArtifactVersionFullSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument The source of the gallery artifact version.
     */
    @JvmName("plkuyvkaleghiuay")
    public suspend
    fun source(argument: suspend GalleryArtifactVersionFullSourceArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryArtifactVersionFullSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): GalleryImageVersionStorageProfileArgs =
        GalleryImageVersionStorageProfileArgs(
            dataDiskImages = dataDiskImages,
            osDiskImage = osDiskImage,
            source = source,
        )
}
