@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetDedicatedHostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated host. 'UserData' is not supported for dedicated host.
 * @property hostGroupName The name of the dedicated host group.
 * @property hostName The name of the dedicated host.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDedicatedHostPlainArgs(
    public val expand: String? = null,
    public val hostGroupName: String,
    public val hostName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetDedicatedHostPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetDedicatedHostPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetDedicatedHostPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .hostGroupName(hostGroupName.let({ args0 -> args0 }))
            .hostName(hostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDedicatedHostPlainArgs].
 */
@PulumiTagMarker
public class GetDedicatedHostPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var hostGroupName: String? = null

    private var hostName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' will retrieve the list of instance views of the dedicated host. 'UserData' is not supported for dedicated host.
     */
    @JvmName("qvpefjayrvnfhikn")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the dedicated host group.
     */
    @JvmName("xjqjxoebefsqfihd")
    public suspend fun hostGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostGroupName = mapped
    }

    /**
     * @param value The name of the dedicated host.
     */
    @JvmName("pnpfwwuupwyafjfy")
    public suspend fun hostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kbfouprtmnuqxqcf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDedicatedHostPlainArgs = GetDedicatedHostPlainArgs(
        expand = expand,
        hostGroupName = hostGroupName ?: throw PulumiNullFieldException("hostGroupName"),
        hostName = hostName ?: throw PulumiNullFieldException("hostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
