@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetGalleryApplicationVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property galleryApplicationName The name of the gallery Application Definition in which the Application Version resides.
 * @property galleryApplicationVersionName The name of the gallery Application Version to be retrieved.
 * @property galleryName The name of the Shared Application Gallery in which the Application Definition resides.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetGalleryApplicationVersionPlainArgs(
    public val expand: String? = null,
    public val galleryApplicationName: String,
    public val galleryApplicationVersionName: String,
    public val galleryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetGalleryApplicationVersionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetGalleryApplicationVersionPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetGalleryApplicationVersionPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .galleryApplicationName(galleryApplicationName.let({ args0 -> args0 }))
            .galleryApplicationVersionName(galleryApplicationVersionName.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryApplicationVersionPlainArgs].
 */
@PulumiTagMarker
public class GetGalleryApplicationVersionPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var galleryApplicationName: String? = null

    private var galleryApplicationVersionName: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("akigfnpetgwumuwc")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the gallery Application Definition in which the Application Version resides.
     */
    @JvmName("unaeecrhltoioyir")
    public suspend fun galleryApplicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryApplicationName = mapped
    }

    /**
     * @param value The name of the gallery Application Version to be retrieved.
     */
    @JvmName("wpnhcbtwcbsaoeib")
    public suspend fun galleryApplicationVersionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryApplicationVersionName = mapped
    }

    /**
     * @param value The name of the Shared Application Gallery in which the Application Definition resides.
     */
    @JvmName("lpklikhcaigxtkfx")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tllbetepknpuhark")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryApplicationVersionPlainArgs =
        GetGalleryApplicationVersionPlainArgs(
            expand = expand,
            galleryApplicationName = galleryApplicationName ?: throw
                PulumiNullFieldException("galleryApplicationName"),
            galleryApplicationVersionName = galleryApplicationVersionName ?: throw
                PulumiNullFieldException("galleryApplicationVersionName"),
            galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
