@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetGalleryImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property galleryImageName The name of the gallery image definition to be retrieved.
 * @property galleryName The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetGalleryImagePlainArgs(
    public val galleryImageName: String,
    public val galleryName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetGalleryImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetGalleryImagePlainArgs =
        com.pulumi.azurenative.compute.inputs.GetGalleryImagePlainArgs.builder()
            .galleryImageName(galleryImageName.let({ args0 -> args0 }))
            .galleryName(galleryName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryImagePlainArgs].
 */
@PulumiTagMarker
public class GetGalleryImagePlainArgsBuilder internal constructor() {
    private var galleryImageName: String? = null

    private var galleryName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the gallery image definition to be retrieved.
     */
    @JvmName("mshseapsjwnfppdd")
    public suspend fun galleryImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the Shared Image Gallery from which the Image Definitions are to be retrieved.
     */
    @JvmName("rofpgieskptfhghw")
    public suspend fun galleryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rovswylgqrrjpmgu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryImagePlainArgs = GetGalleryImagePlainArgs(
        galleryImageName = galleryImageName ?: throw PulumiNullFieldException("galleryImageName"),
        galleryName = galleryName ?: throw PulumiNullFieldException("galleryName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
