@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetRestorePointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation. 'InstanceView' retrieves information about the run-time state of a restore point.
 * @property resourceGroupName The name of the resource group.
 * @property restorePointCollectionName The name of the restore point collection.
 * @property restorePointName The name of the restore point.
 */
public data class GetRestorePointPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val restorePointCollectionName: String,
    public val restorePointName: String,
) : ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetRestorePointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.compute.inputs.GetRestorePointPlainArgs =
        com.pulumi.azurenative.compute.inputs.GetRestorePointPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .restorePointCollectionName(restorePointCollectionName.let({ args0 -> args0 }))
            .restorePointName(restorePointName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRestorePointPlainArgs].
 */
@PulumiTagMarker
public class GetRestorePointPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var restorePointCollectionName: String? = null

    private var restorePointName: String? = null

    /**
     * @param value The expand expression to apply on the operation. 'InstanceView' retrieves information about the run-time state of a restore point.
     */
    @JvmName("wdmyqsgivbqhychr")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kovdigxitkurlykp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the restore point collection.
     */
    @JvmName("hcpueqmvjnwkwuiv")
    public suspend fun restorePointCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restorePointCollectionName = mapped
    }

    /**
     * @param value The name of the restore point.
     */
    @JvmName("qlulltkhdjwpucev")
    public suspend fun restorePointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restorePointName = mapped
    }

    internal fun build(): GetRestorePointPlainArgs = GetRestorePointPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        restorePointCollectionName = restorePointCollectionName ?: throw
            PulumiNullFieldException("restorePointCollectionName"),
        restorePointName = restorePointName ?: throw PulumiNullFieldException("restorePointName"),
    )
}
