@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.compute.kotlin.inputs

import com.pulumi.azurenative.compute.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The expand expression to apply on the operation.
 * @property resourceGroupName The name of the resource group.
 * @property runCommandName The name of the virtual machine run command.
 * @property vmName The name of the virtual machine containing the run command.
 */
public data class GetVirtualMachineRunCommandByVirtualMachinePlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val runCommandName: String,
    public val vmName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.compute.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgs =
        com.pulumi.azurenative.compute.inputs.GetVirtualMachineRunCommandByVirtualMachinePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .runCommandName(runCommandName.let({ args0 -> args0 }))
            .vmName(vmName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualMachineRunCommandByVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualMachineRunCommandByVirtualMachinePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var runCommandName: String? = null

    private var vmName: String? = null

    /**
     * @param value The expand expression to apply on the operation.
     */
    @JvmName("nnbgkfflmqbhkipf")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rxymnmiqjtibosdi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine run command.
     */
    @JvmName("deefjwywsglpxfdu")
    public suspend fun runCommandName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.runCommandName = mapped
    }

    /**
     * @param value The name of the virtual machine containing the run command.
     */
    @JvmName("lcicxcpbjojiqaoj")
    public suspend fun vmName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmName = mapped
    }

    internal fun build(): GetVirtualMachineRunCommandByVirtualMachinePlainArgs =
        GetVirtualMachineRunCommandByVirtualMachinePlainArgs(
            expand = expand,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            runCommandName = runCommandName ?: throw PulumiNullFieldException("runCommandName"),
            vmName = vmName ?: throw PulumiNullFieldException("vmName"),
        )
}
